/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.util;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpUtils {
    private static final IUserManagerService userManagerService = UserManagerService.userInstance();

    public static Map<String, String> setHeader() {
        return HttpUtils.setHeader(null, new TenantId[0]);
    }

    public static Map<String, String> setHeader(String driveToken, TenantId ... tenantId) {
        return HttpUtils.setHeader(driveToken, null, tenantId);
    }

    public static Map<String, String> setHeader(String driveToken, String discardTenantId, TenantId ... tenantId) {
        return HttpUtils.setHeader(driveToken, discardTenantId, null, tenantId);
    }

    public static Map<String, String> setHeader(String driveToken, String discardTenantId, FileInfo fileInfo, TenantId ... tenantId) {
        String finalTenantId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtil.isEmpty(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put("digi-middleware-auth-user", userToken);
        } else {
            headers.put("digi-middleware-drive-access", driveToken);
        }
        if (!StringUtil.isEmpty(discardTenantId)) {
            headers.put("tenantId", discardTenantId);
        }
        if (fileInfo != null) {
            try {
                headers.put("digi-middleware-drive-arg", URLEncoder.encode(ObjectMapperUtil.writeValueAsString(fileInfo), StandardCharsets.UTF_8.name()));
            }
            catch (JsonProcessingException | UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if ((finalTenantId = TenantId.getId(fileInfo, tenantId)) != null) {
            headers.put("digi-middleware-auth-access", "dmc-sdk:" + finalTenantId);
        }
        HttpUtils.setHeaderApp(headers);
        return headers;
    }

    public static Map<String, String> setHeaderAdmin() {
        return HttpUtils.setHeaderAdmin(null);
    }

    public static Map<String, String> setHeaderAdmin(String discardTenantId) {
        String finalTenantId;
        HashMap<String, String> headers = new HashMap<String, String>();
        String userToken = userManagerService.getUserToken(ServerSetting.getAdmin());
        headers.put("digi-middleware-auth-user", userToken);
        if (!StringUtil.isEmpty(discardTenantId)) {
            headers.put("tenantId", discardTenantId);
        }
        if ((finalTenantId = TenantId.getId(null, new TenantId[0])) != null) {
            headers.put("digi-middleware-auth-access", "dmc-sdk:" + finalTenantId);
        }
        HttpUtils.setHeaderApp(headers);
        return headers;
    }

    public static void setHeaderApp(Map<String, String> headers) {
        headers.put("digi-middleware-auth-app", ServerSetting.getAppToken());
        headers.put("digi-middleware-auth-app-secret", ServerSetting.getAppSecret());
    }
}

