package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.utils.IOUtils;
import com.digiwin.dap.middleware.commons.crypto.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class InputStreamEncryptionStrategy extends AbstractEncryptionStrategy<InputStream> {

    protected static final Logger logger = LoggerFactory.getLogger(InputStreamEncryptionStrategy.class);

    public InputStreamEncryptionStrategy(byte[] aesKey) {
        super(aesKey);
    }

    @Override
    public InputStream encrypted(InputStream inputStream) {
        super.check(inputStream);
        try {
            byte[] ciphertext = AES.encryptIvCBC(IOUtils.readStreamAsByteArray(inputStream), aesKey);
            if (ciphertext.length > 0) {
                return new ByteArrayInputStream(ciphertext);
            }
        } catch (Exception e) {
            throw new DMCException("inputStream加密异常!", e);
        }
        throw new DMCException("inputStream加密后为空!");
    }

}
