package com.digiwin.dap.middleware.dmc.common.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.internal.DMCConstants;
import org.apache.commons.codec.binary.Base64;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * DMC内部工具栏
 *
 * @author fobgochod
 * @date 2024/2/2 17:37
 */
public class DMCUtils {

    private static final List<String> ROOT_DIR = new ArrayList<String>() {{
        add("0");
        add(null);
        add("null");
        add(DMCConstants.EMPTY_UUID_STR);
    }};

    private static boolean isRootDir(String dirId) {
        return ROOT_DIR.contains(dirId);
    }

    /**
     * 获取有效的目录ID
     *
     * @param dirId 目录ID
     */
    public static String getDirId(String dirId) {
        if (isRootDir(dirId)) {
            return DMCConstants.EMPTY_UUID_STR;
        }
        return dirId;
    }

    /**
     * 校验token是否过期
     *
     * @param token 密钥
     * @return 是否正确
     */
    public static boolean isExpires(String token) {
        try {
            DecodedJWT jwt = JWT.decode(token);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(Calendar.SECOND, 30);
            return cal.getTime().after(jwt.getExpiresAt());
        } catch (Exception exception) {
            return true;
        }
    }

    /**
     * 密码加密
     *
     * @param data 原始密码
     */
    public static String sha256(String data) {
        MessageDigest messageDigest;
        String encodeStr;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(data.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = messageDigest.digest();
            messageDigest.update(bytes);
            encodeStr = Base64.encodeBase64String(messageDigest.digest());
        } catch (Exception e) {
            throw new DMCException(String.format("[%s]加密错误：%s", data, e.getMessage()));
        }
        return encodeStr;
    }

}
