package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.DMCException;

import java.util.List;

/**
 * DMC user config info
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class DMCLogin {

    /**
     * 配置信息
     */
    protected String uri;
    protected String bucket;
    private String username;
    private String password;
    private String pwdhash;
    private String tenantId = DMCConstants.DEFAULT_TENANT;
    /**
     * 延时登录
     */
    private boolean lazy;
    private String appToken;
    private String appSecret;
    private List<String> appIds;

    public static void check(DMCLogin config) {
        if (config == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.null"));
        }
        if (config.getUri() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.uri.null"));
        }
        if (config.getBucket() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.bucket.null"));
        }
        if (config.getUsername() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.username.null"));
        }
        if (config.getPwdhash() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.password.null"));
        }
    }

    public static String uniqueKey(String username, String tenantId) {
        return String.format("%s::%s", username, tenantId == null ? DMCConstants.DEFAULT_TENANT : tenantId);
    }

    public String uniqueKey() {
        return uniqueKey(username, tenantId);
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getBucket() {
        return bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPwdhash() {
        return pwdhash;
    }

    public void setPwdhash(String pwdhash) {
        this.pwdhash = pwdhash;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isLazy() {
        return lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String getAppToken() {
        return appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public List<String> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<String> appIds) {
        this.appIds = appIds;
    }
}
