package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.internal.client.parser.ResponseV1Parsers;
import com.digiwin.dap.middleware.dmc.model.BatchRequest;

/**
 * 删除
 *
 * @author fobgochod
 * @date 2023/8/7 11:05
 */
public class DeleteV1Operation extends DMCOperation {

    public DeleteV1Operation(ServiceClient client) {
        super(client);
    }

    /**
     * 删除文件(回收站)<br>
     * {@link HttpMethod#DELETE} - /api/dmc/v1/buckets/{bucket}/files/{fileId}
     */

    public String delete(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDeleteUrlV1(original.getBucket(), original.getFileId()))
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseV1Parsers.recycleBinIdResponseParser);
    }

    /**
     * 删除目录<br>
     * {@link HttpMethod#DELETE} - /api/dmc/v1/buckets/{bucket}/directorys/{dirId}
     */
    public String deleteDir(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDeleteDirUrlV1(original.getBucket(), original.getDirId()))
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseV1Parsers.recycleBinIdResponseParser);
    }

    /**
     * 批量删除文件(回收站)<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/files/delete/batch
     */
    public void deleteMulti(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDeleteMultiUrlV1(original.getBucket()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    /**
     * 删除文件<br>
     * {@link HttpMethod#DELETE} - /api/dmc/v1/buckets/{bucket}/files/{fileId}/force
     */
    public void deleteForce(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDeleteForceUrlV1(original.getBucket(), original.getFileId()))
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }
}
