package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

import java.util.HashMap;
import java.util.Map;

/**
 * @author geyao
 * @date 2025/9/8
 */
public class BucketConfigRequest extends GenericRequest {

    private Boolean enableWhitelist;

    private Boolean checkOnlineToken;

    public Boolean getEnableWhitelist() {
        return enableWhitelist;
    }

    public void setEnableWhitelist(Boolean enableWhitelist) {
        this.enableWhitelist = enableWhitelist;
    }

    public Boolean getCheckOnlineToken() {
        return checkOnlineToken;
    }

    public void setCheckOnlineToken(Boolean checkOnlineToken) {
        this.checkOnlineToken = checkOnlineToken;
    }

    @Override
    public HttpEntity build() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("enableWhitelist", enableWhitelist);
        map.put("checkOnlineToken", checkOnlineToken);
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(map))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
