/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.app;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCSystemConfigOperation;
import com.digiwin.dap.middleware.dmc.model.UserAppRequest;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AppCache {
    private DMCSystemConfigOperation dmcSystemConfigOperation;
    private static final List<String> APP_IDS = new CopyOnWriteArrayList<String>();

    public void setDmcSystemConfigOperation(DMCSystemConfigOperation dmcSystemConfigOperation) {
        this.dmcSystemConfigOperation = dmcSystemConfigOperation;
    }

    public synchronized void syncAppIds(DMCConfig dmcConfig) {
        if (!APP_IDS.isEmpty()) {
            return;
        }
        if (dmcConfig.getAppIds() == null || dmcConfig.getAppIds().isEmpty()) {
            return;
        }
        try {
            APP_IDS.addAll(dmcConfig.getAppIds());
            for (String appId : dmcConfig.getAppIds()) {
                UserAppRequest request = new UserAppRequest();
                request.setAppId(appId);
                this.dmcSystemConfigOperation.addUserAppRelation(request);
            }
        }
        catch (Exception e) {
            APP_IDS.clear();
            throw new RuntimeException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("FailedToBindAppId", new Object[0]), e);
        }
    }

    public int getAppIdSize() {
        return APP_IDS.size();
    }
}

