/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.utils;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCUploadEncryptionOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public final class FileUtils {
    public static OutputStream newOutputStream(String filePath, String fileName) throws IOException {
        Path dir = Paths.get(filePath, new String[0]);
        Files.createDirectories(dir, new FileAttribute[0]);
        return Files.newOutputStream(dir.resolve(fileName), new OpenOption[0]);
    }

    private static File createNewFile(String filePath, String fileName) throws IOException {
        Path dir = Paths.get(filePath, new String[0]);
        Files.createDirectories(dir, new FileAttribute[0]);
        File file = dir.resolve(fileName).toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static byte[] readFileToByteArray(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] byteArray = new byte[(int)file.length()];
            fis.read(byteArray);
            fis.close();
            return byteArray;
        }
        catch (Exception e) {
            throw new DMCException("\u6587\u4ef6\u8f6c\u5b57\u8282\u6570\u7ec4\u5f02\u5e38", e);
        }
    }

    public static File writeByteArrayToFile(byte[] byteArray, String fileName) {
        try {
            String resourcePath = DMCUploadEncryptionOperation.class.getResource("/").getPath();
            File tempDir = new File(resourcePath, "temp");
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            File tempFile = new File(tempDir, fileName);
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(byteArray);
            fos.close();
            return tempFile;
        }
        catch (Exception e) {
            throw new DMCException("\u5199\u5165\u6587\u4ef6\u5f02\u5e38", e);
        }
    }
}

