/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.utils;

import com.digiwin.dap.middleware.dmc.common.comm.io.RepeatableFileInputStream;
import com.digiwin.dap.middleware.dmc.common.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.CheckedInputStream;

public class IOUtils {
    public static String readStreamAsString(InputStream in, String charset) throws IOException {
        try {
            String string = StreamUtils.copyToString(in, Charset.forName(charset));
            return string;
        }
        finally {
            in.close();
        }
    }

    public static byte[] readStreamAsByteArray(InputStream in) throws IOException {
        return StreamUtils.copyToByteArray(in);
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean checkFile(File file) {
        if (file == null) {
            return false;
        }
        boolean exists = false;
        boolean isFile = false;
        boolean canRead = false;
        try {
            exists = file.exists();
            isFile = file.isFile();
            canRead = file.canRead();
        }
        catch (SecurityException se) {
            return false;
        }
        return exists && isFile && canRead;
    }

    public static InputStream newRepeatableInputStream(InputStream original) throws IOException {
        InputStream repeatable = null;
        repeatable = !original.markSupported() ? (original instanceof FileInputStream ? new RepeatableFileInputStream((FileInputStream)original) : new BufferedInputStream(original, 524288)) : original;
        return repeatable;
    }

    public static Long getCRCValue(InputStream inputStream) {
        if (inputStream instanceof CheckedInputStream) {
            return ((CheckedInputStream)inputStream).getChecksum().getValue();
        }
        return null;
    }

    public static InputStream stringToInputStream(String text) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
        ((InputStream)inputStream).close();
        return inputStream;
    }
}

