/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.security.DigitalEnvelopeBuilder;
import com.digiwin.dap.middleware.dmc.common.security.encryption.strategy.EncryptionStrategyFactory;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadPartV1Request;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadV1Request;
import com.digiwin.dap.middleware.dmc.internal.client.parser.ResponseV1Parsers;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;

public class UploadV1EncryptionOperation
extends DMCOperation {
    private final DigitalEnvelopeBuilder digitalEnvelopeBuilder;
    private final EncryptionStrategyFactory encryptionStrategyFactory;

    public UploadV1EncryptionOperation(ServiceClient client, EncryptionStrategyFactory encryptionStrategyFactory, DigitalEnvelopeBuilder digitalEnvelopeBuilder) {
        super(client);
        this.digitalEnvelopeBuilder = digitalEnvelopeBuilder;
        this.encryptionStrategyFactory = encryptionStrategyFactory;
    }

    public FileInfo upload(UploadV1Request original) throws Exception {
        original.setBytes(this.encryptionStrategyFactory.strategy(original.getBytes()));
        original.setFile(this.encryptionStrategyFactory.strategy(original.getFile()));
        original.setInput(this.encryptionStrategyFactory.strategy(original.getInput()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadUrlV1(original.getBucket())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        return this.doOperation(request, ResponseV1Parsers.fileInfoResponseParser);
    }

    public FileInfo uploadCover(UploadV1Request original) throws Exception {
        original.setBytes(this.encryptionStrategyFactory.strategy(original.getBytes()));
        original.setFile(this.encryptionStrategyFactory.strategy(original.getFile()));
        original.setInput(this.encryptionStrategyFactory.strategy(original.getInput()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadCoverUrlV1(original.getBucket(), original.getFileId())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        return this.doOperation(request, ResponseV1Parsers.fileInfoResponseParser);
    }

    public ShareInfo uploadShare(UploadV1Request original) throws Exception {
        original.setBytes(this.encryptionStrategyFactory.strategy(original.getBytes()));
        original.setFile(this.encryptionStrategyFactory.strategy(original.getFile()));
        original.setInput(this.encryptionStrategyFactory.strategy(original.getInput()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadShareUrlV1(original.getBucket())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        return this.doOperation(request, ResponseV1Parsers.shareInfoResponseParser);
    }

    public FileInfo claimFileId(UploadPartV1Request original) throws Exception {
        original.setParts(this.encryptionStrategyFactory.strategy(original.getParts()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getClaimFileIdUrlV1(original.getBucket())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        return this.doOperation(request, ResponseV1Parsers.fileInfoResponseParser);
    }

    public FileInfo uploadPart(UploadPartV1Request original) throws Exception {
        original.setParts(this.encryptionStrategyFactory.strategy(original.getParts()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadPartUrlV1(original.getBucket(), original.getFileId(), original.getFrom(), original.getTo(), original.getTotal())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        return this.doOperation(request, ResponseV1Parsers.fileInfoResponseParser);
    }

    public FileInfo uploadPartCover(UploadPartV1Request original) throws Exception {
        original.setParts(this.encryptionStrategyFactory.strategy(original.getParts()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadPartCoverUrlV1(original.getBucket(), original.getFileId(), original.getFrom(), original.getTo(), original.getTotal())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        return this.doOperation(request, ResponseV1Parsers.fileInfoResponseParser);
    }
}

