package com.digiwin.dap.middleware.dmc.common.app;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCSystemConfigOperation;
import com.digiwin.dap.middleware.dmc.model.UserAppRequest;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * @author geyao
 * @date 2025/9/12
 */
public class AppCache {

    private DMCSystemConfigOperation dmcSystemConfigOperation;

    private static final List<String> APP_IDS = new CopyOnWriteArrayList<>();

    public void setDmcSystemConfigOperation(DMCSystemConfigOperation dmcSystemConfigOperation) {
        this.dmcSystemConfigOperation = dmcSystemConfigOperation;
    }

    /**
     * 同步appId集合
     */
    public synchronized void syncAppIds(DMCConfig dmcConfig) {
        if (!APP_IDS.isEmpty()) {
            return;
        }
        if (dmcConfig.getAppIds() == null || dmcConfig.getAppIds().isEmpty()) {
            return;
        }

        try {
            APP_IDS.addAll(dmcConfig.getAppIds());
            for (String appId : dmcConfig.getAppIds()) {
                UserAppRequest request = new UserAppRequest();
                request.setAppId(appId);
                dmcSystemConfigOperation.addUserAppRelation(request);
            }
        } catch (Exception e) {
            APP_IDS.clear();
            throw new RuntimeException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("FailedToBindAppId"), e);
        }
    }

    public int getAppIdSize() {
        return APP_IDS.size();
    }
}
