package com.digiwin.dap.middleware.dmc.common.context;

/**
 * 存放登陆用户信息
 *
 * @author fobgochod
 * @since 5.1.0.0
 */
public final class TenantHolder {

    private static final ThreadLocal<String> contextHolder = new ThreadLocal<>();

    TenantHolder() {
    }

    /**
     * 请空当前线程数据
     */
    public static void clearContext() {
        contextHolder.remove();
    }

    /**
     * 获取当前登录成功的数据
     */
    public static String getContext() {
        return contextHolder.get();
    }

    /**
     * 设置当前登录的数据
     */
    public static void setContext(String context) {
        contextHolder.set(context);
    }
}
