package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.internal.client.OSSConfig;

import java.net.URI;

/**
 * DMC service side request paths
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class DMCConfig extends OSSConfig {

    /**
     * login
     */
    private static final String LOGIN = "%s/api/dmc/v1/auth/login";
    private static final String REFRESH = "%s/api/dmc/v1/auth/token/refresh";
    /**
     * file upload
     */
    private static final String UPLOAD = "%s/api/dmc/v2/file/%s/upload";
    private static final String UPLOAD_COVER = "%s/api/dmc/v2/file/%s/upload/cover";
    private static final String UPLOAD_MULTI = "%s/api/dmc/v2/file/%s/upload/multi";
    /**
     * file multipart upload
     */
    private static final String UPLOAD_EMPTY = "%s/api/dmc/v1/buckets/%s/files/segment";
    private static final String UPLOAD_MULTIPART = "%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s/%s";
    /**
     * file download
     */
    private static final String DOWNLOAD = "%s/api/dmc/v2/file/%s/download/%s";
    private static final String DOWNLOAD_MULTI = "%s/api/dmc/v2/file/%s/download/multi";
    /**
     * file delete
     */
    private static final String DELETE = "%s/api/dmc/v2/file/%s/delete/%s";
    private static final String DELETE_MULTI = "%s/api/dmc/v2/file/%s/delete";
    private static final String DELETE_FORCE = "%s/api/dmc/v2/file/%s/delete/force/%s";
    private static final String DELETE_FORCE_MULTI = "%s/api/dmc/v2/file/%s/delete/force";
    /**
     * file recycle bin
     */
    private static final String RECYCLE = "%s/api/dmc/v2/file/%s/recycle/delete/%s";
    private static final String RECYCLE_MULTI = "%s/api/dmc/v2/file/%s/recycle/delete";
    private static final String RECYCLE_CLEAR = "%s/api/dmc/v2/file/%s/recycle/clear";
    private static final String RECYCLE_RESTORE = "%s/api/dmc/v2/file/%s/recycle/restore/%s";
    private static final String RECYCLE_RESTORE_MULTI = "%s/api/dmc/v2/file/%s/recycle/restore";
    private static final String RESTORE_MULTI = "%s/api/dmc/v2/file/%s/recycle/restore/file";
    /**
     * file copy
     */
    private static final String COPY = "%s/api/dmc/v2/file/%s/copy/%s/%s";
    private static final String COPY_DIR = "%s/api/dmc/v2/file/%s/copy/dir/%s/%s";
    private static final String COPY_MULTI = "%s/api/dmc/v2/file/%s/copy/%s";
    /**
     * file move
     */
    private static final String MOVE = "%s/api/dmc/v2/file/%s/move/%s/%s";
    private static final String MOVE_DIR = "%s/api/dmc/v2/file/%s/move/dir/%s/%s";
    private static final String MOVE_MULTI = "%s/api/dmc/v2/file/%s/move/%s";
    /**
     * file share
     */
    private static final String SHARE_MULTI = "%s/api/dmc/v2/file/%s/share";
    private static final String SHARE_DELETE_MULTI = "%s/api/dmc/v2/file/%s/share/delete";
    /**
     * file image handle
     */
    private static final String IMAGE_UPLOAD = "%s/api/dmc/v1/buckets/%s/images/upload?shrink=1&width=%s&height=%s";
    private static final String IMAGE_SHRINK = "%s/api/dmc/v1/buckets/%s/images/%s?shrink=1&width=%s&height=%s&share=%s";
    private static final String IMAGE = "%s/api/dmc/v1/buckets/%s/images/%s/%s";
    /**
     * directory crud
     */
    private static final String DIR_ADD = "%s/api/dmc/v2/directory/%s";
    private static final String DIR_RENAME = "%s/api/dmc/v2/directory/%s/rename";
    private static final String DIR_MOD = "%s/api/dmc/v2/directory/%s";
    private static final String DIR_GET = "%s/api/dmc/v2/directory/%s/%s";
    private static final String DIR_GET_BY_NAME = "%s/api/dmc/v2/directory/%s/info";
    /**
     * fileinfo crud
     */
    private static final String FILE_RENAME = "%s/api/dmc/v2/fileinfo/%s/rename";
    private static final String FILE_MOD = "%s/api/dmc/v2/fileinfo/%s";
    private static final String FILE_GET = "%s/api/dmc/v2/fileinfo/%s/%s";
    private static final String FILE_GET_BY_NAME = "%s/api/dmc/v2/fileinfo/%s/info";
    private static final String FILES_GET_BY_DIR_ID = "%s/api/dmc/v2/fileinfo/%s/directory/%s";
    private static final String FILES_GET_BY_IDS = "%s/api/dmc/v2/fileinfo/%s/ids";

    /**
     * bucket crud
     */
    private static final String BUCKETS_GET_BY_NAME = "%s/api/dmc/v2/buckets/name/%s";
    private static final String MODIFY_BUCKET_CONFIG = "%s/api/dmc/v2/buckets/config/%s/edit";

    /**
     * whitelist
     */
    private static final String WHITELIST_GET_BY_SCENE = "%s/api/dmc/v2/whitelist/custom/%s/%s";
    private static final String MODIFY_WHITELIST = "%s/api/dmc/v2/whitelist/custom/%s";

    /**
     * system user app relation
     */
    private static final String ADD_USER_APP_RELATION = "%s/api/dmc/v2/user/apps/add";
    private static final String DELETE_USER_APP_RELATION = "%s/api/dmc/v2/user/apps/delete";
    private static final String EXIST_USER_APP_RELATION = "%s/api/dmc/v2/user/apps/exist?appId=%s";

    public URI getLoginUrl() {
        return URI.create(String.format(LOGIN, uri));
    }

    public URI getRefreshUrl() {
        return URI.create(String.format(REFRESH, uri));
    }

    public URI getUploadUrl() {
        return URI.create(String.format(UPLOAD, uri, bucket));
    }

    public URI getUploadCoverUrl() {
        return URI.create(String.format(UPLOAD_COVER, uri, bucket));
    }

    public URI getUploadMultiUrl() {
        return URI.create(String.format(UPLOAD_MULTI, uri, bucket));
    }

    public URI getUploadEmptyUrl() {
        return URI.create(String.format(UPLOAD_EMPTY, uri, bucket));
    }

    public URI getUploadMultipartUrl(String fileId, long from, long to, long total, int partNum) {
        return URI.create(String.format(UPLOAD_MULTIPART, uri, bucket, fileId, from, to, total, partNum));
    }

    public URI getDownloadUrl(String fileId) {
        return URI.create(String.format(DOWNLOAD, uri, bucket, fileId));
    }

    public URI getDownloadMultiUrl() {
        return URI.create(String.format(DOWNLOAD_MULTI, uri, bucket));
    }

    public URI getDeleteUrl(String fileId) {
        return URI.create(String.format(DELETE, uri, bucket, fileId));
    }

    public URI getDeleteMultiUrl() {
        return URI.create(String.format(DELETE_MULTI, uri, bucket));
    }

    public URI getDeleteForceUrl(String fileId) {
        return URI.create(String.format(DELETE_FORCE, uri, bucket, fileId));
    }

    public URI getDeleteForceMultiUrl() {
        return URI.create(String.format(DELETE_FORCE_MULTI, uri, bucket));
    }

    public URI getRecycleUrl(String recycleId) {
        return URI.create(String.format(RECYCLE, uri, bucket, recycleId));
    }

    public URI getRecycleMultiUrl() {
        return URI.create(String.format(RECYCLE_MULTI, uri, bucket));
    }

    public URI getRecycleClearUrl() {
        return URI.create(String.format(RECYCLE_CLEAR, uri, bucket));
    }

    public URI getRecycleRestoreUrl(String recycleId) {
        return URI.create(String.format(RECYCLE_RESTORE, uri, bucket, recycleId));
    }

    public URI getRecycleRestoreMultiUrl() {
        return URI.create(String.format(RECYCLE_RESTORE_MULTI, uri, bucket));
    }

    public URI getRestoreMultiUrl() {
        return URI.create(String.format(RESTORE_MULTI, uri, bucket));
    }

    public URI getCopyUrl(String fileId, String targetDirId) {
        return URI.create(String.format(COPY, uri, bucket, fileId, targetDirId));
    }

    public URI getCopyDirUrl(String dirId, String targetDirId) {
        return URI.create(String.format(COPY_DIR, uri, bucket, dirId, targetDirId));
    }

    public URI getCopyMultiUrl(String targetDirId) {
        return URI.create(String.format(COPY_MULTI, uri, bucket, targetDirId));
    }

    public URI getMoveUrl(String fileId, String targetDirId) {
        return URI.create(String.format(MOVE, uri, bucket, fileId, targetDirId));
    }

    public URI getMoveDirUrl(String dirId, String targetDirId) {
        return URI.create(String.format(MOVE_DIR, uri, bucket, dirId, targetDirId));
    }

    public URI getMoveMultiUrl(String targetDirId) {
        return URI.create(String.format(MOVE_MULTI, uri, bucket, targetDirId));
    }

    public URI getShareMultiUrl() {
        return URI.create(String.format(SHARE_MULTI, uri, bucket));
    }

    public URI getShareDeleteMultiUrl() {
        return URI.create(String.format(SHARE_DELETE_MULTI, uri, bucket));
    }

    public URI getImageUploadUrl(int width, int height) {
        return URI.create(String.format(IMAGE_UPLOAD, uri, bucket, width, height));
    }

    public URI getImageShrinkUrl(String fileId, int width, int height, boolean share) {
        return URI.create(String.format(IMAGE_SHRINK, uri, bucket, fileId, width, height, share));
    }

    public URI getImageUrl(String fileId, boolean shrink) {
        return URI.create(String.format(IMAGE, uri, bucket, fileId, shrink));
    }

    public URI getDirInfoAddUrl() {
        return URI.create(String.format(DIR_ADD, uri, bucket));
    }

    public URI getDirInfoRenameUrl() {
        return URI.create(String.format(DIR_RENAME, uri, bucket));
    }

    public URI getDirInfoModUrl() {
        return URI.create(String.format(DIR_MOD, uri, bucket));
    }

    public URI getDirInfoGetUrl(String dirId) {
        return URI.create(String.format(DIR_GET, uri, bucket, dirId));
    }

    public URI getDirInfoGetByNameUrl() {
        return URI.create(String.format(DIR_GET_BY_NAME, uri, bucket));
    }

    public URI getFileInfoRenameUrl() {
        return URI.create(String.format(FILE_RENAME, uri, bucket));
    }

    public URI getFileInfoModUrl() {
        return URI.create(String.format(FILE_MOD, uri, bucket));
    }

    public URI getFileInfoGetUrl(String fileId) {
        return URI.create(String.format(FILE_GET, uri, bucket, fileId));
    }

    public URI getFileInfoByNameUrl() {
        return URI.create(String.format(FILE_GET_BY_NAME, uri, bucket));
    }

    public URI getFileInfosGetUrl(String dirId) {
        return URI.create(String.format(FILES_GET_BY_DIR_ID, uri, bucket, dirId));
    }

    public URI getFileInfosGetUrl() {
        return URI.create(String.format(FILES_GET_BY_IDS, uri, bucket));
    }

    public URI getBucketInfoByNameUrl() {
        return URI.create(String.format(BUCKETS_GET_BY_NAME, uri, bucket));
    }

    public URI getModifyBucketConfigUrl() {
        return URI.create(String.format(MODIFY_BUCKET_CONFIG, uri, bucket));
    }

    public URI getWhitelistBySceneUrl(String sceneId) {
        return URI.create(String.format(WHITELIST_GET_BY_SCENE, uri, bucket, sceneId));
    }

    public URI getModifyWhitelistUrl() {
        return URI.create(String.format(MODIFY_WHITELIST, uri, bucket));
    }

    public URI getAddUserAppRelationUrl() {
        return URI.create(String.format(ADD_USER_APP_RELATION, uri));
    }

    public URI getDeleteUserAppRelationUrl() {
        return URI.create(String.format(DELETE_USER_APP_RELATION, uri));
    }

    public URI getExistUserAppRelationUrl(String appId) {
        return URI.create(String.format(EXIST_USER_APP_RELATION, uri, appId));
    }

}
