package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.internal.client.model.ShareV1Request;
import com.digiwin.dap.middleware.dmc.internal.client.parser.ResponseV1Parsers;

import java.util.List;

/**
 * 分享
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class ShareV1Operation extends DMCOperation {

    public ShareV1Operation(ServiceClient client) {
        super(client);
    }

    /**
     * 文件永久分享给所有人<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/ShareFiles
     */
    public List<String> share(ShareV1Request original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileShareUrlV1(original.getBucket()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseV1Parsers.shareUrlResponseParser);
    }

    /**
     * 文件限时分享给所有人<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/ShareFiles/d/{expireDay}
     */
    public List<String> shareDay(ShareV1Request original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileShareDayUrlV1(original.getBucket(), original.getExpireDay()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseV1Parsers.shareUrlResponseParser);
    }

    /**
     * 取消分享<br>
     * {@link HttpMethod#DELETE} - /api/dmc/v1/{bucket}/deleteShareFile/{shareId}
     */
    public void deleteShare(ShareV1Request original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileShareDelUrlV1(original.getBucket(), original.getShareId()))
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }
}


