package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.BucketConfigRequest;
import com.digiwin.dap.middleware.dmc.model.UserAppRequest;
import com.digiwin.dap.middleware.dmc.model.Whitelist;
import com.digiwin.dap.middleware.dmc.model.WhitelistRequest;

public class DMCSystemConfigOperation extends DMCOperation {

    public DMCSystemConfigOperation(ServiceClient client) {
        super(client);
    }

    public void modifyBucketConfig(BucketConfigRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getModifyBucketConfigUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .setOnlySysAccountAccess(true)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public Whitelist getWhitelistByScene(WhitelistRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getWhitelistBySceneUrl(original.getSceneId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .setOnlySysAccountAccess(true)
                .build();
        return doOperation(request, ResponseParsers.whitelistResponseParser);
    }

    public void addWhitelist(WhitelistRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getModifyWhitelistUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .setOnlySysAccountAccess(true)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void modifyWhitelist(WhitelistRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getModifyWhitelistUrl())
                .setMethod(HttpMethod.PUT)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .setOnlySysAccountAccess(true)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void deleteWhitelist(WhitelistRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getModifyWhitelistUrl())
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .setOnlySysAccountAccess(true)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void addUserAppRelation(UserAppRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getAddUserAppRelationUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .setForceRetry(true)
                .setOnlySysAccountAccess(true)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void deleteUserAppRelation(UserAppRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDeleteUserAppRelationUrl())
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .setOnlySysAccountAccess(true)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public boolean checkUserAppRelation(UserAppRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getExistUserAppRelationUrl(original.getAppId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .setOnlySysAccountAccess(true)
                .build();
        return doOperation(request, ResponseParsers.booleanResponseParser);
    }
}