package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author geyao
 * @date 2025/9/5
 */
public class WhitelistRequest extends GenericRequest {

    /**
     * 场景Id
     */
    private String sceneId;

    /**
     * 正常扩展名
     */
    private List<String> normalExtensions;

    /**
     * 正则扩展名
     */
    private List<String> regexExtensions;

    public String getSceneId() {
        return sceneId;
    }

    public void setSceneId(String sceneId) {
        this.sceneId = sceneId;
    }

    public List<String> getNormalExtensions() {
        return normalExtensions;
    }

    public void setNormalExtensions(List<String> normalExtensions) {
        this.normalExtensions = normalExtensions;
    }

    public List<String> getRegexExtensions() {
        return regexExtensions;
    }

    public void setRegexExtensions(List<String> regexExtensions) {
        this.regexExtensions = regexExtensions;
    }

    @Override
    public HttpEntity build() {
        Map<String, Object> map = new HashMap<>(3);
        map.put("sceneId", sceneId);
        map.put("normalExtensions", normalExtensions);
        map.put("regexExtensions", regexExtensions);
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(map))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
