package com.digiwin.dmc.sdk.service;

import com.digiwin.dmc.sdk.entity.DriveAuthRequest;

/**
 * 获取DriveToken，会在本地缓存，如果超过还有30秒过期，则会再去服务器获取
 *
 * @author chenxsa
 */
@Deprecated
public interface IDriveTokenService {
    /**
     * 获取DriveToken
     *
     * @param authRequest 需要操作的文件或文件夹
     * @return token
     */
    String getDriveToken(DriveAuthRequest authRequest);

    /**
     * 获取DriveToken
     *
     * @param tenantId    租户Id
     * @param authRequest 需要操作的文件或文件夹
     * @return DriveToken
     */
    String getDriveTokenByTenant(String tenantId, DriveAuthRequest authRequest);


    /**
     * 获取目录读DriveToken
     *
     * @param dirId 目录id
     * @return token
     */
    String getDirWriteDriveToken(String dirId);


    /**
     * 获取目录读DriveToken
     *
     * @param dirId 目录id
     * @return token
     */
    String getDirReadDriveToken(String dirId);

    /**
     * 获取文件读DriveToken
     *
     * @param fileId 文件id
     * @return token
     */
    String getFileReadDriveToken(String fileId);

    /**
     * 获取文件写DriveToken
     *
     * @param fileId 文件id
     * @return token
     */
    String getFileWriteDriveToken(String fileId);
}
