/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.dmc.ClientConfiguration;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.comm.DefaultServiceClient;
import com.digiwin.dap.middleware.dmc.common.context.IamUserTokenHolder;
import com.digiwin.dap.middleware.dmc.common.context.TenantHolder;
import com.digiwin.dap.middleware.dmc.common.utils.FileCopyUtils;
import com.digiwin.dap.middleware.dmc.common.utils.FileUtils;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.client.OSSClient;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCBaseOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCCopyOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCDeleteOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCDownloadOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCImageOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCLoginOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCMoveOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCRecycleOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCShareOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCSystemConfigOperation;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCUploadOperation;
import com.digiwin.dap.middleware.dmc.model.BatchRequest;
import com.digiwin.dap.middleware.dmc.model.BucketConfigRequest;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.DirRequest;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfosRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpTree;
import com.digiwin.dap.middleware.dmc.model.IamUserToken;
import com.digiwin.dap.middleware.dmc.model.ImageInfo;
import com.digiwin.dap.middleware.dmc.model.ImageRequest;
import com.digiwin.dap.middleware.dmc.model.ImageUpload;
import com.digiwin.dap.middleware.dmc.model.MultipartUploadRequest;
import com.digiwin.dap.middleware.dmc.model.RecycleBin;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.dmc.model.ShareRequest;
import com.digiwin.dap.middleware.dmc.model.UploadCoverRequest;
import com.digiwin.dap.middleware.dmc.model.UploadMultiRequest;
import com.digiwin.dap.middleware.dmc.model.UploadRequest;
import com.digiwin.dap.middleware.dmc.model.UserAppRequest;
import com.digiwin.dap.middleware.dmc.model.Whitelist;
import com.digiwin.dap.middleware.dmc.model.WhitelistRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMCClient
extends OSSClient
implements DMC {
    private static final Logger logger = LoggerFactory.getLogger(DMCClient.class);
    private DMCLoginOperation loginOperation;
    private DMCUploadOperation uploadOperation;
    private DMCDownloadOperation downloadOperation;
    private DMCDeleteOperation deleteOperation;
    private DMCRecycleOperation recycleOperation;
    private DMCCopyOperation copyOperation;
    private DMCMoveOperation moveOperation;
    private DMCShareOperation shareOperation;
    private DMCImageOperation imageOperation;
    private DMCBaseOperation baseOperation;
    private DMCSystemConfigOperation systemConfigOperation;

    DMCClient(DMCConfig config) {
        this(config, null);
    }

    DMCClient(DMCConfig config, ClientConfiguration clientConfig) {
        DMCConfig.check(config);
        this.serviceClient = clientConfig == null ? new DefaultServiceClient(config) : new DefaultServiceClient(config, clientConfig);
        this.initOperations();
        this.serviceClient.getAuthCache().setLoginOperation(this.loginOperation);
        this.serviceClient.getAppCache().setDmcSystemConfigOperation(this.systemConfigOperation);
        if (!config.isLazy()) {
            this.serviceClient.setAuthCache(config.getTenantId());
        }
    }

    protected static List<FileInfo> toFileInfo(List<String> filenames) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        filenames.forEach(filename -> fileInfos.add(new FileInfo((String)filename)));
        return fileInfos;
    }

    protected static List<FileInfo> toFileInfo(Map<String, FileInfo> filenames) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (Map.Entry<String, FileInfo> entry : filenames.entrySet()) {
            FileInfo fileInfo = entry.getValue();
            fileInfo.setFileName(entry.getKey());
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    @Override
    public void initOperations() {
        super.initOperations();
        this.loginOperation = new DMCLoginOperation(this.serviceClient);
        this.uploadOperation = new DMCUploadOperation(this.serviceClient);
        this.downloadOperation = new DMCDownloadOperation(this.serviceClient);
        this.deleteOperation = new DMCDeleteOperation(this.serviceClient);
        this.recycleOperation = new DMCRecycleOperation(this.serviceClient);
        this.copyOperation = new DMCCopyOperation(this.serviceClient);
        this.moveOperation = new DMCMoveOperation(this.serviceClient);
        this.shareOperation = new DMCShareOperation(this.serviceClient);
        this.imageOperation = new DMCImageOperation(this.serviceClient);
        this.baseOperation = new DMCBaseOperation(this.serviceClient);
        this.systemConfigOperation = new DMCSystemConfigOperation(this.serviceClient);
    }

    @Override
    public String copy(String fileId) throws Exception {
        return this.copy(fileId, "00000000-0000-0000-0000-000000000000");
    }

    @Override
    public String copy(String fileId, String targetDirId) throws Exception {
        FileOpRequest request = new FileOpRequest();
        request.setFileId(fileId);
        request.setTargetDirId(targetDirId);
        return this.copyOperation.copy(request);
    }

    @Override
    public String copyDir(String dirId) throws Exception {
        return this.copyDir(dirId, "00000000-0000-0000-0000-000000000000");
    }

    @Override
    public String copyDir(String dirId, String targetDirId) throws Exception {
        FileOpRequest request = new FileOpRequest();
        request.setDirId(dirId);
        request.setTargetDirId(targetDirId);
        return this.copyOperation.copyDir(request);
    }

    @Override
    public List<FileOpTree> batchCopy(List<String> fileIds, List<String> dirIds, String targetDirId) throws Exception {
        FileOpRequest request = new FileOpRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        request.setTargetDirId(targetDirId);
        return this.batchCopy(request);
    }

    @Override
    public List<FileOpTree> batchCopy(FileOpRequest request) throws Exception {
        return this.copyOperation.copyMulti(request);
    }

    @Override
    public void move(String fileId) throws Exception {
        this.move(fileId, "00000000-0000-0000-0000-000000000000");
    }

    @Override
    public void move(String fileId, String targetDirId) throws Exception {
        FileOpRequest request = new FileOpRequest();
        request.setFileId(fileId);
        request.setTargetDirId(targetDirId);
        this.moveOperation.move(request);
    }

    @Override
    public void moveDir(String dirId) throws Exception {
        this.moveDir(dirId, "00000000-0000-0000-0000-000000000000");
    }

    @Override
    public void moveDir(String dirId, String targetDirId) throws Exception {
        FileOpRequest request = new FileOpRequest();
        request.setDirId(dirId);
        request.setTargetDirId(targetDirId);
        this.moveOperation.moveDir(request);
    }

    @Override
    public void batchMove(List<String> fileIds, List<String> dirIds, String targetDirId) throws Exception {
        FileOpRequest request = new FileOpRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        request.setTargetDirId(targetDirId);
        this.moveOperation.moveMulti(request);
    }

    @Override
    public void batchMove(FileOpRequest request) throws Exception {
        this.moveOperation.moveMulti(request);
    }

    @Override
    public void delete(String fileId) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileId(fileId);
        this.deleteOperation.deleteForce(request);
    }

    @Override
    public void deleteDir(String dirId) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setDirIds(Collections.singletonList(dirId));
        this.batchDelete(request);
    }

    @Override
    public void batchDelete(List<String> fileIds, List<String> dirIds) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        this.batchDelete(request);
    }

    @Override
    public void batchDelete(BatchRequest request) throws Exception {
        this.deleteOperation.deleteForceMulti(request);
    }

    @Override
    public FileInfo upload(File file) throws Exception {
        return this.upload(file, "00000000-0000-0000-0000-000000000000");
    }

    @Override
    public FileInfo upload(File file, String dirId) throws Exception {
        return this.upload(file, null, dirId);
    }

    @Override
    public FileInfo upload(File file, String filename, String dirId) throws Exception {
        return this.upload(file, new FileInfo(filename, dirId));
    }

    @Override
    public FileInfo upload(File file, FileInfo fileInfo) throws Exception {
        UploadRequest request = new UploadRequest();
        request.setFile(file);
        request.setFileInfo(fileInfo);
        return this.upload(request);
    }

    @Override
    public FileInfo upload(byte[] bytes, String filename) throws Exception {
        return this.upload(bytes, filename, "00000000-0000-0000-0000-000000000000");
    }

    @Override
    public FileInfo upload(byte[] bytes, String filename, String dirId) throws Exception {
        return this.upload(bytes, new FileInfo(filename, dirId));
    }

    @Override
    public FileInfo upload(byte[] bytes, FileInfo fileInfo) throws Exception {
        UploadRequest request = new UploadRequest();
        request.setBytes(bytes);
        request.setFileInfo(fileInfo);
        return this.upload(request);
    }

    @Override
    public FileInfo upload(InputStream input, String filename) throws Exception {
        return this.upload(input, filename, "00000000-0000-0000-0000-000000000000");
    }

    @Override
    public FileInfo upload(InputStream input, String filename, String dirId) throws Exception {
        return this.upload(input, new FileInfo(filename, dirId));
    }

    @Override
    public FileInfo upload(InputStream input, FileInfo fileInfo) throws Exception {
        UploadRequest request = new UploadRequest();
        request.setInput(input);
        request.setFileInfo(fileInfo);
        return this.upload(request);
    }

    @Override
    public FileInfo upload(UploadRequest request) throws Exception {
        return this.uploadOperation.upload(request);
    }

    @Override
    public FileInfo coverUpload(String fileId, File file) throws Exception {
        UploadCoverRequest request = new UploadCoverRequest();
        request.setFileId(fileId);
        request.setFile(file);
        return this.uploadOperation.coverUpload(request);
    }

    @Override
    public FileInfo coverUpload(String fileId, byte[] bytes) throws Exception {
        FileInfo fileInfo = this.getFileInfo(fileId);
        if (fileInfo == null) {
            throw new DMCException(String.format("\u6587\u4ef6[%s]\u4e0d\u5b58\u5728", fileId));
        }
        UploadCoverRequest request = new UploadCoverRequest();
        request.setFileId(fileId);
        request.setFileInfo(fileInfo);
        request.setBytes(bytes);
        return this.uploadOperation.coverUpload(request);
    }

    @Override
    public FileInfo coverUpload(String fileId, InputStream input) throws Exception {
        FileInfo fileInfo = this.getFileInfo(fileId);
        if (fileInfo == null) {
            throw new DMCException(String.format("\u6587\u4ef6[%s]\u4e0d\u5b58\u5728", fileId));
        }
        UploadCoverRequest request = new UploadCoverRequest();
        request.setFileId(fileId);
        request.setFileInfo(fileInfo);
        request.setInput(input);
        return this.uploadOperation.coverUpload(request);
    }

    @Override
    public List<FileInfo> batchUpload(List<File> files) throws Exception {
        UploadMultiRequest request = new UploadMultiRequest();
        request.setFiles(files);
        return this.batchUpload(request);
    }

    @Override
    public List<FileInfo> batchUpload(List<File> files, List<FileInfo> fileInfos) throws Exception {
        UploadMultiRequest request = new UploadMultiRequest();
        request.setFiles(files);
        request.setFileInfos(fileInfos);
        return this.batchUpload(request);
    }

    @Override
    public List<FileInfo> batchUploadBytes(List<byte[]> bytes, List<String> filenames) throws Exception {
        UploadMultiRequest request = new UploadMultiRequest();
        request.setBytes(bytes);
        request.setFileInfos(DMCClient.toFileInfo(filenames));
        return this.batchUpload(request);
    }

    @Override
    public List<FileInfo> batchUploadBytes(List<byte[]> bytes, Map<String, FileInfo> fileInfos) throws Exception {
        UploadMultiRequest request = new UploadMultiRequest();
        request.setBytes(bytes);
        request.setFileInfos(DMCClient.toFileInfo(fileInfos));
        return this.batchUpload(request);
    }

    @Override
    public List<FileInfo> batchUploadStream(List<InputStream> inputs, List<String> filenames) throws Exception {
        UploadMultiRequest request = new UploadMultiRequest();
        request.setInputs(inputs);
        request.setFileInfos(DMCClient.toFileInfo(filenames));
        return this.batchUpload(request);
    }

    @Override
    public List<FileInfo> batchUploadStream(List<InputStream> inputs, Map<String, FileInfo> fileInfos) throws Exception {
        UploadMultiRequest request = new UploadMultiRequest();
        request.setInputs(inputs);
        request.setFileInfos(DMCClient.toFileInfo(fileInfos));
        return this.batchUpload(request);
    }

    @Override
    public List<FileInfo> batchUpload(UploadMultiRequest request) throws Exception {
        return this.uploadOperation.uploadMulti(request);
    }

    @Override
    public String multipartUpload(File file) throws Exception {
        return this.multipartUpload(file, 2611200);
    }

    @Override
    public String multipartUpload(File file, int partSize) throws Exception {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(file.getName());
        return this.multipartUpload(file, fileInfo, partSize);
    }

    @Override
    public String multipartUpload(File file, FileInfo fileInfo) throws Exception {
        return this.multipartUpload(file, fileInfo, 2611200);
    }

    @Override
    public String multipartUpload(File file, FileInfo fileInfo, int partSize) throws Exception {
        MultipartUploadRequest request = new MultipartUploadRequest();
        request.setFile(file);
        request.setFileInfo(fileInfo);
        request.setFileLength(file.length());
        request.setPartSize(partSize);
        return this.multipartUpload(request);
    }

    @Override
    public String multipartUpload(InputStream input, FileInfo fileInfo) throws Exception {
        return this.multipartUpload(input, fileInfo, 2611200);
    }

    @Override
    public String multipartUpload(InputStream input, FileInfo fileInfo, int partSize) throws Exception {
        MultipartUploadRequest request = new MultipartUploadRequest();
        request.setInput(input);
        request.setFileInfo(fileInfo);
        request.setFileLength(fileInfo.getSize());
        request.setPartSize(partSize);
        return this.multipartUpload(request);
    }

    @Override
    public String multipartUpload(MultipartUploadRequest request) throws Exception {
        return this.uploadOperation.multipartUpload(request);
    }

    @Override
    public byte[] download(String fileId) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setFileId(fileId);
        return this.downloadOperation.download(request);
    }

    @Override
    public void download(String fileId, String filePath) throws Exception {
        String fileName = this.getFileInfo(fileId).getFileName();
        this.download(fileId, filePath, fileName);
    }

    @Override
    public void download(String fileId, String filePath, String fileName) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setFileId(fileId);
        byte[] bytes = this.downloadOperation.download(request);
        FileCopyUtils.copy(bytes, FileUtils.newOutputStream(filePath, fileName));
    }

    @Override
    public void download(String fileId, OutputStream output) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setFileId(fileId);
        byte[] bytes = this.downloadOperation.download(request);
        output.write(bytes);
    }

    @Override
    public byte[] batchDownload(List<String> fileIds, List<String> dirIds) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        return this.batchDownload(request);
    }

    @Override
    public void batchDownload(List<String> fileIds, List<String> dirIds, String filePath) throws Exception {
        String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".zip";
        this.batchDownload(fileIds, dirIds, filePath, fileName);
    }

    @Override
    public void batchDownload(List<String> fileIds, List<String> dirIds, String filePath, String fileName) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        byte[] bytes = this.batchDownload(request);
        FileCopyUtils.copy(bytes, FileUtils.newOutputStream(filePath, fileName));
    }

    @Override
    public void batchDownload(List<String> fileIds, List<String> dirIds, OutputStream output) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        byte[] bytes = this.batchDownload(request);
        output.write(bytes);
    }

    @Override
    public byte[] batchDownload(BatchRequest request) throws Exception {
        return this.downloadOperation.downloadMulti(request);
    }

    @Override
    public List<ImageInfo> getImageInfo(String fileId) throws Exception {
        return this.getImageInfo(fileId, true);
    }

    @Override
    public List<ImageInfo> getImageInfo(String fileId, boolean resize) throws Exception {
        ImageRequest request = new ImageRequest();
        request.setFileId(fileId);
        request.setShrink(resize);
        return this.imageOperation.imageInfo(request);
    }

    @Override
    public ImageInfo resizeImageWidth(String fileId, int width) throws Exception {
        return this.resizeImage(fileId, width, 0, true);
    }

    @Override
    public ImageInfo resizeImageWidth(String fileId, int width, boolean share) throws Exception {
        return this.resizeImage(fileId, width, 0, share);
    }

    @Override
    public ImageInfo resizeImageHeight(String fileId, int height) throws Exception {
        return this.resizeImage(fileId, 0, height, true);
    }

    @Override
    public ImageInfo resizeImageHeight(String fileId, int height, boolean share) throws Exception {
        return this.resizeImage(fileId, 0, height, share);
    }

    @Override
    public ImageInfo resizeImage(String fileId, int width, int height) throws Exception {
        return this.resizeImage(fileId, width, height, true);
    }

    @Override
    public ImageInfo resizeImage(String fileId, int width, int height, boolean share) throws Exception {
        ImageRequest request = new ImageRequest();
        request.setFileId(fileId);
        request.setShrink(true);
        request.setWidth(width);
        request.setHeight(height);
        request.setShare(share);
        return this.imageOperation.imageShrink(request);
    }

    @Override
    public ImageUpload resizeImage(File image, FileInfo imageInfo) throws Exception {
        return this.resizeImage(image, imageInfo, 0, 0);
    }

    @Override
    public ImageUpload resizeImageWidth(File image, FileInfo imageInfo, int width) throws Exception {
        return this.resizeImage(image, imageInfo, width, 0);
    }

    @Override
    public ImageUpload resizeImageHeight(File image, FileInfo imageInfo, int height) throws Exception {
        return this.resizeImage(image, imageInfo, 0, height);
    }

    @Override
    public ImageUpload resizeImage(File image, FileInfo imageInfo, int width, int height) throws Exception {
        ImageRequest request = new ImageRequest();
        request.setFile(image);
        request.setFileInfo(imageInfo);
        request.setShrink(true);
        request.setWidth(width);
        request.setHeight(height);
        request.addHeader("digi-middleware-drive-arg", URLEncoder.encode(JsonUtils.writeValue((Object)imageInfo), "UTF-8"));
        return this.imageOperation.imageUpload(request);
    }

    @Override
    public RecycleBin remove(String fileId) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileId(fileId);
        return this.deleteOperation.delete(request);
    }

    @Override
    public RecycleBin removeDir(String dirId) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setDirIds(Collections.singletonList(dirId));
        return this.batchRemove(request).get(0);
    }

    @Override
    public List<RecycleBin> batchRemove(List<String> fileIds, List<String> dirIds) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileIds(fileIds);
        request.setDirIds(dirIds);
        return this.batchRemove(request);
    }

    @Override
    public List<RecycleBin> batchRemove(BatchRequest request) throws Exception {
        return this.deleteOperation.deleteMulti(request);
    }

    @Override
    public void deleteRecycleBin(String recycleId) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setRecycleId(recycleId);
        this.recycleOperation.recycleDelete(request);
    }

    @Override
    public void batchDeleteRecycleBin(List<String> recycleIds) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setRecycleIds(recycleIds);
        this.recycleOperation.recycleDeleteMulti(request);
    }

    @Override
    public void clearRecycleBin() throws Exception {
        BatchRequest request = new BatchRequest();
        this.recycleOperation.recycleClear(request);
    }

    @Override
    public void restoreRecycleBin(String recycleId) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setRecycleId(recycleId);
        this.recycleOperation.recycleRestore(request);
    }

    @Override
    public void batchRestoreRecycleBin(List<String> recycleIds) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setRecycleIds(recycleIds);
        this.batchRestoreRecycleBin(request);
    }

    @Override
    public void batchRestoreRecycleBin(BatchRequest request) throws Exception {
        this.recycleOperation.recycleRestoreMulti(request);
    }

    @Override
    public void restore(String fileId) throws Exception {
        this.batchRestore(Collections.singletonList(fileId));
    }

    @Override
    public void batchRestore(List<String> fileIds) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setFileIds(fileIds);
        this.recycleOperation.restoreMulti(request);
    }

    @Override
    public ShareInfo share(String fileId) throws Exception {
        ShareRequest request = new ShareRequest();
        request.setFileId(fileId);
        return this.share(request);
    }

    @Override
    public ShareInfo share(String fileId, LocalDateTime expireDate) throws Exception {
        ShareRequest request = new ShareRequest();
        request.setFileId(fileId);
        request.setExpireDate(expireDate);
        return this.share(request);
    }

    @Override
    public ShareInfo share(String fileId, int allowCount) throws Exception {
        ShareRequest request = new ShareRequest();
        request.setFileId(fileId);
        request.setAllowCount(allowCount);
        return this.share(request);
    }

    @Override
    public ShareInfo share(String fileId, int allowCount, boolean deleteFile) throws Exception {
        ShareRequest request = new ShareRequest();
        request.setFileId(fileId);
        request.setAllowCount(allowCount);
        request.setDeleteFile(deleteFile);
        return this.share(request);
    }

    @Override
    public ShareInfo share(ShareRequest request) throws Exception {
        return this.shareOperation.shareMulti(request);
    }

    @Override
    public void deleteShare(String shareId) throws Exception {
        this.batchDeleteShare(Collections.singletonList(shareId));
    }

    @Override
    public void batchDeleteShare(List<String> shareIds) throws Exception {
        BatchRequest request = new BatchRequest();
        request.setShareIds(shareIds);
        this.shareOperation.shareDeleteMulti(request);
    }

    @Override
    public DirInfo createDir(DirInfo dirInfo) throws Exception {
        DirRequest request = new DirRequest();
        request.setDirInfo(dirInfo);
        return this.baseOperation.addDirInfo(request);
    }

    @Override
    public DirInfo renameDir(String dirId, String dirName) throws Exception {
        DirRequest request = new DirRequest();
        DirInfo dirInfo = new DirInfo();
        dirInfo.setId(dirId);
        dirInfo.setName(dirName);
        request.setDirInfo(dirInfo);
        return this.baseOperation.renameDir(request);
    }

    @Override
    public DirInfo modDirInfo(DirInfo dirInfo) throws Exception {
        DirRequest request = new DirRequest();
        request.setDirInfo(dirInfo);
        return this.baseOperation.modDirInfo(request);
    }

    @Override
    public DirInfo getDirInfo(String dirId) throws Exception {
        DirRequest request = new DirRequest();
        request.setDirId(dirId);
        return this.baseOperation.getDirInfo(request);
    }

    @Override
    public DirInfo getDirInfoByName(String dirName) throws Exception {
        return this.getDirInfoByName("00000000-0000-0000-0000-000000000000", dirName);
    }

    @Override
    public DirInfo getDirInfoByName(String parentDirId, String dirName) throws Exception {
        DirRequest request = new DirRequest();
        DirInfo dirInfo = new DirInfo();
        dirInfo.setParentId(com.digiwin.dap.middleware.dmc.common.utils.DMCUtils.getDirId(parentDirId));
        dirInfo.setName(dirName);
        request.setDirInfo(dirInfo);
        IamUserToken iamUserToken = IamUserTokenHolder.getContext();
        try {
            return this.baseOperation.getDirInfoByName(request);
        }
        catch (DMCException e) {
            if ("20404".equals(e.getErrorCode())) {
                if (iamUserToken != null && iamUserToken.isUseOnce()) {
                    IamUserTokenHolder.setContext(iamUserToken);
                }
                return this.getDirInfoByNameV1(parentDirId, dirName);
            }
            throw e;
        }
    }

    @Override
    public FileInfo renameFile(String fileId, String fileName) throws Exception {
        FileInfoRequest request = new FileInfoRequest();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setId(fileId);
        fileInfo.setFileName(fileName);
        request.setFileInfo(fileInfo);
        return this.baseOperation.renameFile(request);
    }

    @Override
    public FileInfo modFileInfo(FileInfo fileInfo) throws Exception {
        FileInfoRequest request = new FileInfoRequest();
        request.setFileInfo(fileInfo);
        return this.baseOperation.modFileInfo(request);
    }

    @Override
    public FileInfo modFileExpireDate(String fileId, LocalDateTime expireDate) throws Exception {
        FileInfo fileInfo = this.getFileInfo(fileId);
        fileInfo.setExpireDate(expireDate);
        return this.modFileInfo(fileInfo);
    }

    @Override
    public FileInfo modFileDirectoryId(String fileId, String dirId) throws Exception {
        FileInfo fileInfo = this.getFileInfo(fileId);
        fileInfo.setDirectoryId(dirId);
        return this.modFileInfo(fileInfo);
    }

    @Override
    public FileInfo getFileInfo(String fileId) throws Exception {
        FileInfoRequest request = new FileInfoRequest();
        request.setFileId(fileId);
        return this.baseOperation.getFileInfo(request);
    }

    @Override
    public FileInfo getFileInfoByName(String fileName) throws Exception {
        return this.getFileInfoByName("00000000-0000-0000-0000-000000000000", fileName);
    }

    @Override
    public FileInfo getFileInfoByName(String dirId, String fileName) throws Exception {
        FileInfoRequest request = new FileInfoRequest();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDirectoryId(dirId);
        fileInfo.setFileName(fileName);
        request.setFileInfo(fileInfo);
        return this.baseOperation.getFileInfoByName(request);
    }

    @Override
    public List<FileInfo> getFileInfos(String dirId) throws Exception {
        FileInfosRequest request = new FileInfosRequest();
        request.setDirId(dirId);
        return this.baseOperation.getFileInfoByDirId(request);
    }

    @Override
    public List<FileInfo> getFileInfos(List<String> fileIds) throws Exception {
        FileInfosRequest request = new FileInfosRequest();
        request.setFileIds(fileIds);
        return this.baseOperation.getFileInfoByIds(request);
    }

    @Override
    public Whitelist getUploadWhitelist(String sceneId) throws Exception {
        WhitelistRequest request = new WhitelistRequest();
        request.setSceneId(sceneId);
        return this.systemConfigOperation.getWhitelistByScene(request);
    }

    @Override
    public void addUploadWhitelist(Whitelist whitelist) throws Exception {
        WhitelistRequest request = new WhitelistRequest();
        request.setSceneId(whitelist.getSceneId());
        request.setNormalExtensions(whitelist.getNormalExtensions());
        request.setRegexExtensions(whitelist.getRegexExtensions());
        this.systemConfigOperation.addWhitelist(request);
    }

    @Override
    public void updateUploadWhitelist(Whitelist whitelist) throws Exception {
        WhitelistRequest request = new WhitelistRequest();
        request.setSceneId(whitelist.getSceneId());
        request.setNormalExtensions(whitelist.getNormalExtensions());
        request.setRegexExtensions(whitelist.getRegexExtensions());
        this.systemConfigOperation.modifyWhitelist(request);
    }

    @Override
    public void deleteUploadWhitelist(String sceneId) throws Exception {
        WhitelistRequest request = new WhitelistRequest();
        request.setSceneId(sceneId);
        this.systemConfigOperation.deleteWhitelist(request);
    }

    @Override
    public boolean checkAppIdExist(String appId) throws Exception {
        UserAppRequest request = new UserAppRequest();
        request.setAppId(appId);
        return this.systemConfigOperation.checkUserAppRelation(request);
    }

    @Override
    public void addAppId(String appId) throws Exception {
        UserAppRequest request = new UserAppRequest();
        request.setAppId(appId);
        this.systemConfigOperation.addUserAppRelation(request);
    }

    @Override
    public void deleteAppId(String appId) throws Exception {
        UserAppRequest request = new UserAppRequest();
        request.setAppId(appId);
        this.systemConfigOperation.deleteUserAppRelation(request);
    }

    @Override
    public void updateBucketConfig(boolean enableWhitelist, boolean checkOnlineToken) throws Exception {
        BucketConfigRequest request = new BucketConfigRequest();
        request.setEnableWhitelist(enableWhitelist);
        request.setCheckOnlineToken(checkOnlineToken);
        this.systemConfigOperation.modifyBucketConfig(request);
    }

    @Override
    public void enableUploadWhitelist(boolean enableUploadWhitelist) throws Exception {
        BucketConfigRequest request = new BucketConfigRequest();
        request.setEnableWhitelist(enableUploadWhitelist);
        this.systemConfigOperation.modifyBucketConfig(request);
    }

    @Override
    public void enableOnlinePreviewToken(boolean enableOnlinePreviewToken) throws Exception {
        BucketConfigRequest request = new BucketConfigRequest();
        request.setCheckOnlineToken(enableOnlinePreviewToken);
        this.systemConfigOperation.modifyBucketConfig(request);
    }

    @Override
    public DMC setIamUserToken(String iamUserToken) {
        IamUserTokenHolder.setContext(IamUserToken.of(iamUserToken));
        return this;
    }

    @Override
    public DMC setIamUserToken(String iamUserToken, boolean useOnce) {
        IamUserTokenHolder.setContext(IamUserToken.of(iamUserToken, useOnce));
        return this;
    }

    @Override
    public void clearIamUserToken() {
        IamUserTokenHolder.clearContext();
    }

    @Override
    public String getToken() {
        return this.getToken(this.serviceClient.getConfig().getTenantId());
    }

    @Override
    public String getToken(String tenantId) {
        return this.serviceClient.getAuthCache().getToken(this.serviceClient.getConfig(), tenantId);
    }

    @Override
    public void switchTenantId() {
        this.switchTenantId("default");
    }

    @Override
    public void switchTenantId(String tenantId) {
        TenantHolder.clearContext();
        this.serviceClient.setAuthCache(tenantId);
    }

    @Override
    public DMC setTenantId(String tenantId) {
        String currentTenantId = this.serviceClient.getConfig().getTenantId();
        if (!"default".equals(currentTenantId)) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("SwitchTenantIdDeny", currentTenantId));
        }
        TenantHolder.setContext(tenantId);
        return this;
    }

    @Override
    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        }
        catch (Exception e) {
            logger.error("shutdown throw exception: ", (Throwable)e);
        }
    }

    @Override
    public String getConnectionPoolStats() {
        try {
            return this.serviceClient.getConnectionPoolStats();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

