/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.comm;

import com.digiwin.dap.middleware.dmc.ClientConfiguration;
import com.digiwin.dap.middleware.dmc.common.app.AppCache;
import com.digiwin.dap.middleware.dmc.common.auth.AuthCache;
import com.digiwin.dap.middleware.dmc.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.dmc.common.comm.HttpRequestFactory;
import com.digiwin.dap.middleware.dmc.common.comm.IdleConnectionReaper;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.context.IamUserTokenHolder;
import com.digiwin.dap.middleware.dmc.common.context.TenantHolder;
import com.digiwin.dap.middleware.dmc.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dmc.common.utils.HttpUtil;
import com.digiwin.dap.middleware.dmc.common.utils.StreamUtils;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCConfigBuilder;
import com.digiwin.dap.middleware.dmc.model.IamUserToken;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager;
    protected RequestConfig requestConfig;
    protected DMCConfig config;
    protected AuthCache authCache = new AuthCache();
    protected AppCache appCache = new AppCache();

    public DefaultServiceClient() {
        this(DMCConfigBuilder.create().build());
    }

    public DefaultServiceClient(DMCConfig config) {
        this(config, new ClientConfiguration());
    }

    public DefaultServiceClient(DMCConfig config, ClientConfiguration clientConfig) {
        super(clientConfig);
        this.connectionManager = this.createHttpClientConnectionManager();
        this.httpClient = this.createHttpClient(this.connectionManager);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(clientConfig.getConnectionTimeout());
        builder.setSocketTimeout(clientConfig.getSocketTimeout());
        builder.setConnectionRequestTimeout(clientConfig.getConnectionRequestTimeout());
        this.requestConfig = builder.build();
        this.config = config;
    }

    private static ResponseMessage buildResponse(RequestMessage request, CloseableHttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage();
        response.setUrl(request.getEndpoint().toString());
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        if (httpResponse.getEntity() != null) {
            response.setContent(httpResponse.getEntity().getContent());
            if (!response.isSuccessful()) {
                String content = StreamUtils.copyToString(response.getContent(), StandardCharsets.UTF_8);
                response.setError(content);
            }
        }
        for (Header header : httpResponse.getAllHeaders()) {
            if ("Content-Length".equalsIgnoreCase(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    @Override
    public ResponseMessage sendRequestCore(RequestMessage request, ExecutionContext context) throws IOException {
        CloseableHttpResponse httpResponse;
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request);
        this.bindAppIds(request);
        this.handleCommonToken(request, httpRequest);
        HttpClientContext httpContext = this.createHttpContext(request);
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    private void bindAppIds(RequestMessage request) {
        if (request.isWhitelist()) {
            return;
        }
        int appIdSize = this.appCache.getAppIdSize();
        List<String> appIds = this.config.getAppIds();
        if (appIdSize > 0 || appIds == null || appIds.isEmpty()) {
            return;
        }
        this.appCache.syncAppIds(this.config);
    }

    @Override
    public DMCConfig getConfig() {
        return this.config;
    }

    @Override
    public AuthCache getAuthCache() {
        return this.authCache;
    }

    @Override
    public AppCache getAppCache() {
        return this.appCache;
    }

    @Override
    public synchronized void setAuthCache(String tenantId) {
        this.config.setTenantId(tenantId);
        this.authCache.getToken(this.config);
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    @Override
    public String getConnectionPoolStats() {
        if (this.connectionManager != null && this.connectionManager instanceof PoolingHttpClientConnectionManager) {
            PoolingHttpClientConnectionManager conn = (PoolingHttpClientConnectionManager)this.connectionManager;
            return conn.getTotalStats().toString();
        }
        return "";
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnections());
        connectionManager.setMaxTotal(this.clientConfig.getMaxConnections());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.clientConfig.getSocketTimeout()).build());
        if (this.clientConfig.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.clientConfig.getIdleConnectionTime());
            IdleConnectionReaper.registerConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).disableContentCompression().setRetryHandler(this.clientConfig.getRetryHandler()).addInterceptorLast(this.clientConfig.getResponseInterceptor()).build();
    }

    private void handleCommonToken(RequestMessage request, HttpRequestBase httpRequest) {
        if (!request.isWhitelist()) {
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            if (!request.isOnlySysAccountAccess() && Objects.nonNull(iamUserToken) && !StringUtil.isEmpty(iamUserToken.getUserToken())) {
                httpRequest.setHeader("digi-middleware-auth-user", iamUserToken.getUserToken());
            } else {
                httpRequest.setHeader("digi-middleware-auth-user", this.authCache.getToken(this.config));
            }
            if (Objects.nonNull(iamUserToken) && iamUserToken.isUseOnce()) {
                IamUserTokenHolder.clearContext();
            }
            if ("default".equals(this.config.getTenantId()) && TenantHolder.getContext() != null) {
                this.putHeaderIfAbsent(httpRequest, "digi-middleware-auth-access", "dmc-sdk:" + TenantHolder.getContext());
            }
        }
        this.putHeaderIfAbsent(httpRequest, "digi-middleware-auth-app", this.config.getAppToken());
        this.putHeaderIfAbsent(httpRequest, "digi-middleware-auth-app-secret", this.config.getAppSecret());
    }

    private void putHeaderIfAbsent(HttpRequestBase httpRequest, String name, String value) {
        if (!httpRequest.containsHeader(name)) {
            httpRequest.setHeader(name, value);
        }
    }

    private HttpClientContext createHttpContext(RequestMessage request) {
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        httpContext.setAttribute("dmc-sdk:retry", (Object)request.isForceRetry());
        return httpContext;
    }
}

