/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.comm;

import com.digiwin.dap.middleware.dmc.ClientException;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.comm.RequestHandler;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.event.ProgressInputStream;
import com.digiwin.dap.middleware.dmc.event.ProgressListener;
import com.digiwin.dap.middleware.dmc.event.ProgressPublisher;
import com.digiwin.dap.middleware.dmc.internal.model.WebServiceRequest;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProgressHanlder
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestProgressHanlder.class);

    @Override
    public void handle(RequestMessage request) throws DMCException, ClientException {
        InputStream content;
        WebServiceRequest originalRequest = request.getOriginalRequest();
        ProgressListener listener = originalRequest.getProgressListener();
        Map<String, String> headers = request.getHeaders();
        String s = headers.get("Content-Length");
        if (s != null) {
            try {
                long contentLength = Long.parseLong(s);
                ProgressPublisher.publishRequestContentLength(listener, contentLength);
            }
            catch (NumberFormatException e) {
                logger.error("Cannot parse the Content-Length header of the request: ", (Throwable)e);
            }
        }
        if ((content = request.getContent()) == null) {
            return;
        }
        if (!content.markSupported()) {
            content = new BufferedInputStream(content);
        }
        request.setContent(listener == ProgressListener.NOOP ? content : ProgressInputStream.inputStreamForRequest(content, originalRequest));
    }
}

