/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.model.DownloadPartRequest;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.download.DownloadProcessState;
import com.digiwin.dmc.sdk.service.download.DownloadProgressEventArgs;
import com.digiwin.dmc.sdk.service.download.IDownLoadCallbackable;
import com.digiwin.dmc.sdk.service.download.ISegmentDocumentDownloader;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;

public class SegmentSegmentDocumentDownloader
implements ISegmentDocumentDownloader {
    private final String discardTenantId;
    private final String fileId;
    private final String driveToken;
    private final int bufferSize = NetworkOptions.Default.getPackageSize();
    private final DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();
    private String bucketName;
    private TenantId[] tenantId;
    private OutputStream outputStream;
    private Thread thread;
    private volatile DownloadProcessState state = DownloadProcessState.NotStarted;
    private IDownLoadCallbackable completeCallback;
    private IDownLoadCallbackable progressChangedCallback;

    private SegmentSegmentDocumentDownloader(String discardTenantId, String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        this.discardTenantId = discardTenantId;
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.tenantId = tenantId;
    }

    public SegmentSegmentDocumentDownloader(String discardTenantId, String bucketName, String fileId, String saveToPath, int fileSize, String driveToken, TenantId ... tenantId) {
        this(discardTenantId, bucketName, fileId, driveToken, tenantId);
        try {
            this.outputStream = Files.newOutputStream(Paths.get(saveToPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setTotalBytes(fileSize);
    }

    @Override
    public ISegmentDocumentDownloader beginDownload() {
        if (this.state != DownloadProcessState.NotStarted) {
            throw new OperateException("\u4e0b\u8f7d\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u518d\u6b21\u542f\u52a8\u4e0b\u8f7d\uff0c\u8bf7\u5f00\u542f\u65b0\u7684\u4e0b\u8f7d");
        }
        this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
        Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.discardTenantId, this.tenantId);
        this.continueDownload();
        Runnable runnable = () -> this.multipartDownload(this.bucketName, headers);
        this.thread = ExecutorUtil.THREAD_FACTORY.newThread(runnable);
        this.thread.start();
        return this;
    }

    private void multipartDownload(String bucketName, Map<String, String> headers) {
        try {
            int totalBytes = this.eventArgs.getTotalBytes();
            int downloadBytes = 0;
            while (downloadBytes < totalBytes) {
                if (this.state == DownloadProcessState.Stopped) {
                    return;
                }
                if (this.state == DownloadProcessState.Paused) {
                    LockSupport.park(this.thread);
                    continue;
                }
                int from = downloadBytes;
                if (downloadBytes + this.bufferSize >= totalBytes) {
                    this.download(bucketName, headers, from, totalBytes - downloadBytes);
                    downloadBytes = totalBytes;
                    this.eventArgs.setCompletedBytes(totalBytes);
                    this.eventArgs.setPercentage(1.0);
                    if (this.progressChangedCallback != null) {
                        this.progressChangedCallback.callback(this.eventArgs);
                    }
                    if (this.completeCallback == null) continue;
                    this.completeCallback.callback(this.eventArgs);
                    continue;
                }
                this.download(bucketName, headers, from, this.bufferSize);
                this.eventArgs.setCompletedBytes(downloadBytes += this.bufferSize);
                this.eventArgs.setPercentage((double)Math.round((double)this.eventArgs.getCompletedBytes() * 10000.0 / (double)totalBytes) / 10000.0);
                if (this.progressChangedCallback == null) continue;
                this.progressChangedCallback.callback(this.eventArgs);
            }
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    private void download(String bucketName, Map<String, String> headers, int startPos, int length) {
        DownloadPartRequest request = new DownloadPartRequest();
        request.setBucket(bucketName);
        request.setHeaders(headers);
        request.setFileId(this.fileId);
        request.setOutput(this.outputStream);
        request.setPosition(startPos);
        request.setLength(length);
        ServerSetting.internal().downloadPartV1(request);
    }

    @Override
    public ISegmentDocumentDownloader onProgressChanged(IDownLoadCallbackable callbackable) {
        this.progressChangedCallback = callbackable;
        return this;
    }

    @Override
    public ISegmentDocumentDownloader onCompleted(IDownLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }

    @Override
    public void pauseDownload() {
        this.state = DownloadProcessState.Paused;
    }

    @Override
    public void continueDownload() {
        if (this.state == DownloadProcessState.Paused) {
            LockSupport.unpark(this.thread);
        }
        this.state = DownloadProcessState.Downloading;
    }

    @Override
    public void stopDownload() {
        this.state = DownloadProcessState.Stopped;
    }
}

