/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.model.BatchRequest;
import com.digiwin.dap.middleware.dmc.model.DirRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.BatchOperationIds;
import com.digiwin.dmc.sdk.entity.ContentsResult;
import com.digiwin.dmc.sdk.entity.DirInfo;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IDocumentStorageService;
import com.digiwin.dmc.sdk.service.discard.FileInfoTextService;
import com.digiwin.dmc.sdk.service.download.GeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.IGeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.ISegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.SegmentSegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.upload.CoverGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.CoverSegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.GeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.ICoverGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.ICoverSegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.ISegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.SegmentDocumentUploader;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.File;
import java.util.Map;

public class DocumentStorageService
extends FileInfoTextService
implements IDocumentStorageService {
    public static IDocumentStorageService instance() {
        return Holder.instance;
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(null, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadBytes(bytes, fileInfo);
        return new GeneralDocumentUploader(null, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String localPath, FileInfo fileInfo) {
        return this.uploadDocument(null, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadLocal(localPath, fileInfo);
        return new GeneralDocumentUploader(null, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploader(byte[] bytes, FileInfo fileInfo) {
        return this.getUploader(null, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.getUploader(bucketName, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadBytes(bytes, fileInfo);
        return new SegmentDocumentUploader(null, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String localPath, FileInfo fileInfo) {
        return this.getUploader(null, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, String localPath, FileInfo fileInfo) {
        return this.getUploader(bucketName, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadLocal(localPath, fileInfo);
        return new SegmentDocumentUploader(null, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(byte[] bytes, String fileId, TenantId ... tenantId) {
        return this.coverUploadDocument((String)null, bytes, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, byte[] bytes, String fileId, TenantId ... tenantId) {
        return this.coverUploadDocument((String)null, bytes, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.uploadBytes(bytes, fileId, tenantId);
        return new CoverGeneralDocumentUploader(bucketName, bytes, fileId, driveToken, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String localPath, String fileId, TenantId ... tenantId) {
        return this.coverUploadDocument((String)null, localPath, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, String localPath, String fileId, TenantId ... tenantId) {
        return this.coverUploadDocument((String)null, localPath, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, String localPath, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.uploadLocal(localPath, fileId, tenantId);
        return new CoverGeneralDocumentUploader(bucketName, localPath, fileId, driveToken, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(byte[] bytes, String fileId, TenantId ... tenantId) {
        return this.getUploader((String)null, bytes, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, byte[] bytes, String fileId, TenantId ... tenantId) {
        return this.getUploader(bucketName, bytes, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.uploadBytes(bytes, fileId, tenantId);
        return new CoverSegmentDocumentUploader(bucketName, bytes, fileId, driveToken, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String localPath, String fileId, TenantId ... tenantId) {
        return this.getUploader((String)null, localPath, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, String localPath, String fileId, TenantId ... tenantId) {
        return this.getUploader(bucketName, localPath, fileId, (String)null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, String localPath, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.uploadLocal(localPath, fileId, tenantId);
        return new CoverSegmentDocumentUploader(bucketName, localPath, fileId, driveToken, tenantId);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String fileId, String saveToPath, TenantId ... tenantId) {
        return this.downloadDocument((String)null, fileId, saveToPath, (String)null, tenantId);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String bucketName, String fileId, String saveToPath, TenantId ... tenantId) {
        return this.downloadDocument(bucketName, fileId, saveToPath, (String)null, tenantId);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String bucketName, String fileId, String saveToPath, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.download(fileId, saveToPath, tenantId);
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            FileInfo fileInfo = this.getDocumentInfo(bucketName, fileId, new TenantId[0]);
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new GeneralDocumentDownloader(null, bucketName, fileId, saveToPath, driveToken, tenantId);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String fileId, String saveToPath, TenantId ... tenantId) {
        return this.getDownloader((String)null, fileId, saveToPath, (String)null, tenantId);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String bucketName, String fileId, String saveToPath, TenantId ... tenantId) {
        return this.getDownloader(bucketName, fileId, saveToPath, (String)null, tenantId);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String bucketName, String fileId, String saveToPath, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.download(fileId, saveToPath, tenantId);
        FileInfo fileInfo = this.getDocumentInfo(bucketName, fileId, new TenantId[0]);
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new SegmentSegmentDocumentDownloader(null, bucketName, fileId, saveToPath, (int)fileInfo.getSize(), driveToken, tenantId);
    }

    @Override
    public String deleteDocument(String fileId, TenantId ... tenantId) {
        return this.deleteDocument((String)null, fileId, (String)null, tenantId);
    }

    @Override
    public String deleteDocument(String bucketName, String fileId, TenantId ... tenantId) {
        return this.deleteDocument(bucketName, fileId, (String)null, tenantId);
    }

    @Override
    public String deleteDocument(String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        BatchRequest request = new BatchRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        return ServerSetting.internal().removeV1(request);
    }

    @Override
    public void deleteForce(String fileId, TenantId ... tenantId) {
        this.deleteForce(null, fileId, tenantId);
    }

    @Override
    public void deleteForce(String bucketName, String fileId, TenantId ... tenantId) {
        this.deleteForce(bucketName, fileId, (String)null, tenantId);
    }

    @Override
    public void deleteForce(String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        BatchRequest request = new BatchRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        ServerSetting.internal().deleteV1(request);
    }

    @Override
    public void deleteManyDocument(BatchOperationIds operationIds, TenantId ... tenantId) {
        this.deleteManyDocument((String)null, operationIds, (String)null, tenantId);
    }

    @Override
    public void deleteManyDocument(String bucketName, BatchOperationIds operationIds, TenantId ... tenantId) {
        this.deleteManyDocument(bucketName, operationIds, (String)null, tenantId);
    }

    @Override
    public void deleteManyDocument(String bucketName, BatchOperationIds operationIds, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(operationIds, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        BatchRequest request = new BatchRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileIds(operationIds.getFileIds());
        request.setDirIds(operationIds.getDirIds());
        ServerSetting.internal().batchRemoveV1(request);
    }

    @Override
    public void updateDocument(String fileId, String fileName, TenantId ... tenantId) {
        this.updateDocument((String)null, fileId, fileName, (String)null, tenantId);
    }

    @Override
    public void updateDocument(String bucketName, String fileId, String fileName, TenantId ... tenantId) {
        this.updateDocument(bucketName, fileId, fileName, (String)null, tenantId);
    }

    @Override
    public void updateDocument(String bucketName, String fileId, String fileName, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(fileId, fileName, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        FileInfoRequest request = new FileInfoRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        request.setFileName(fileName);
        ServerSetting.internal().renameV1(request);
    }

    @Override
    public FileInfo getDocumentInfo(String fileId, TenantId ... tenantId) {
        return this.getDocumentInfo((String)null, fileId, (String)null, tenantId);
    }

    @Override
    public FileInfo getDocumentInfo(String bucketName, String fileId, TenantId ... tenantId) {
        return this.getDocumentInfo(bucketName, fileId, (String)null, tenantId);
    }

    @Override
    public FileInfo getDocumentInfo(String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        FileInfoRequest request = new FileInfoRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        return new FileInfo(ServerSetting.internal().getFileInfoV1(request));
    }

    @Override
    public String getDocumentIdByName(String directoryId, String fileName) {
        try {
            com.digiwin.dap.middleware.dmc.model.FileInfo fileInfo = ServerSetting.internal().getFileInfoByName(directoryId, fileName);
            return fileInfo == null ? null : fileInfo.getId();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDocument(String fileId, String targetDirectoryId, TenantId ... tenantId) {
        return this.copyDocument((String)null, fileId, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public String copyDocument(String bucketName, String fileId, String targetDirectoryId, TenantId ... tenantId) {
        return this.copyDocument(bucketName, fileId, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public String copyDocument(String bucketName, String fileId, String targetDirectoryId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        FileOpRequest request = new FileOpRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        request.setTargetDirId(ArgumentUtils.getDirectoryId(targetDirectoryId));
        return ServerSetting.internal().copyV1(request);
    }

    @Override
    public void copyManyDocument(BatchOperationIds operationIds, String targetDirectoryId, TenantId ... tenantId) {
        this.copyManyDocument((String)null, operationIds, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public void copyManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, TenantId ... tenantId) {
        this.copyManyDocument(bucketName, operationIds, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public void copyManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(operationIds, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        FileOpRequest request = new FileOpRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileIds(operationIds.getFileIds());
        request.setDirIds(operationIds.getDirIds());
        request.setTargetDirId(ArgumentUtils.getDirectoryId(targetDirectoryId));
        ServerSetting.internal().batchCopyV1(request);
    }

    @Override
    public void moveDocument(String fileId, String targetDirectoryId, TenantId ... tenantId) {
        this.moveDocument((String)null, fileId, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public void moveDocument(String bucketName, String fileId, String targetDirectoryId, TenantId ... tenantId) {
        this.moveDocument(bucketName, fileId, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public void moveDocument(String bucketName, String fileId, String targetDirectoryId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        FileOpRequest request = new FileOpRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        request.setTargetDirId(ArgumentUtils.getDirectoryId(targetDirectoryId));
        ServerSetting.internal().moveV1(request);
    }

    @Override
    public void moveManyDocument(BatchOperationIds operationIds, String targetDirectoryId, TenantId ... tenantId) {
        this.moveManyDocument((String)null, operationIds, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public void moveManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, TenantId ... tenantId) {
        this.moveManyDocument(bucketName, operationIds, targetDirectoryId, (String)null, tenantId);
    }

    @Override
    public void moveManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.fileInfo(operationIds, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        FileOpRequest request = new FileOpRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileIds(operationIds.getFileIds());
        request.setDirIds(operationIds.getDirIds());
        request.setTargetDirId(ArgumentUtils.getDirectoryId(targetDirectoryId));
        ServerSetting.internal().batchMoveV1(request);
    }

    @Override
    public String createDirectory(String directoryName, String parentDirectoryId) {
        return this.createDirectory(null, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectory(String bucketName, String directoryName, String parentDirectoryId) {
        return this.createDirectory(bucketName, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectory(String bucketName, String directoryName, String parentDirectoryId, String driveToken) {
        ArgumentUtils.directoryName(directoryName);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, new TenantId[0]);
        DirRequest request = new DirRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setDirInfo(new DirInfo(ArgumentUtils.getDirectoryId(parentDirectoryId), directoryName));
        return ServerSetting.internal().createDirV1(request);
    }

    @Override
    public String deleteDirectory(String directoryId) {
        return this.deleteDirectory(null, directoryId, null);
    }

    @Override
    public String deleteDirectory(String bucketName, String directoryId) {
        return this.deleteDirectory(bucketName, directoryId, null);
    }

    @Override
    public String deleteDirectory(String bucketName, String directoryId, String driveToken) {
        ArgumentUtils.directory(directoryId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, new TenantId[0]);
        BatchRequest request = new BatchRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setDirId(directoryId);
        return ServerSetting.internal().removeDirV1(request);
    }

    @Override
    public void updateDirectory(String directoryId, String directoryName) {
        this.updateDirectory(null, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectory(String bucketName, String directoryId, String directoryName) {
        this.updateDirectory(bucketName, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectory(String bucketName, String directoryId, String directoryName, String driveToken) {
        ArgumentUtils.directory(directoryId, directoryName);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, new TenantId[0]);
        DirRequest request = new DirRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setDirId(directoryId);
        request.setDirName(directoryName);
        ServerSetting.internal().renameDirV1(request);
    }

    @Override
    public DirInfo getDirectoryInfo(String directoryId) {
        return this.getDirectoryInfo(null, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfo(String bucketName, String directoryId) {
        return this.getDirectoryInfo(bucketName, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfo(String bucketName, String directoryId, String driveToken) {
        ArgumentUtils.directory(directoryId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, new TenantId[0]);
        DirRequest request = new DirRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setDirId(directoryId);
        return new DirInfo(ServerSetting.internal().getDirInfoV1(request));
    }

    @Override
    public String getDirectoryIdByName(String parentDirectoryId, String directoryName) {
        try {
            com.digiwin.dap.middleware.dmc.model.DirInfo dirInfo = ServerSetting.internal().getDirInfoByName(parentDirectoryId, directoryName);
            return dirInfo == null ? null : dirInfo.getId();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDirectory(String directoryId, String targetDirectoryId) {
        return this.copyDirectory(null, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectory(String bucketName, String directoryId, String targetDirectoryId) {
        return this.copyDirectory(bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectory(String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        ArgumentUtils.directory(directoryId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, new TenantId[0]);
        FileOpRequest request = new FileOpRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setDirId(directoryId);
        request.setTargetDirId(ArgumentUtils.getDirectoryId(targetDirectoryId));
        return ServerSetting.internal().copyDirV1(request);
    }

    @Override
    public void moveDirectory(String directoryId, String targetDirectoryId) {
        this.moveDirectory(null, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectory(String bucketName, String directoryId, String targetDirectoryId) {
        this.moveDirectory(bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectory(String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        ArgumentUtils.directory(directoryId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, new TenantId[0]);
        FileOpRequest request = new FileOpRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setDirId(directoryId);
        request.setTargetDirId(ArgumentUtils.getDirectoryId(targetDirectoryId));
        ServerSetting.internal().moveDirV1(request);
    }

    @Override
    public ContentsResult listContents(String directoryId) {
        return this.listContents(null, directoryId, null);
    }

    @Override
    public ContentsResult listContents(String bucketName, String directoryId) {
        return this.listContents(bucketName, directoryId, null);
    }

    @Override
    public ContentsResult listContents(String bucketName, String directoryId, String driveToken) {
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, new TenantId[0]);
        DirRequest request = new DirRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setDirId(ArgumentUtils.getDirectoryId(directoryId));
        return new ContentsResult(ServerSetting.internal().getDirContentV1(request));
    }

    private static class Holder {
        static final IDocumentStorageService instance = new DocumentStorageService();

        private Holder() {
        }
    }
}

