/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.IamUserTokenHolder;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadV1Request;
import com.digiwin.dap.middleware.dmc.model.IamUserToken;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.upload.ICoverGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;

public class CoverGeneralDocumentUploader
implements ICoverGeneralDocumentUploader {
    private String bucketName;
    private String fileId;
    private String driveToken;
    private TenantId[] tenantId;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private CoverGeneralDocumentUploader(String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.tenantId = tenantId;
    }

    public CoverGeneralDocumentUploader(String bucketName, String localPath, String fileId, String driveToken, TenantId ... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    public CoverGeneralDocumentUploader(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId ... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    @Override
    public ICoverGeneralDocumentUploader upload() {
        try {
            this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
            Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.tenantId);
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Runnable runnable = () -> {
                try {
                    IamUserTokenHolder.setContext(iamUserToken);
                    UploadV1Request request = new UploadV1Request();
                    request.setBucket(this.bucketName);
                    request.setHeaders(headers);
                    request.setInput(this.inputStream);
                    request.setFileId(this.fileId);
                    ServerSetting.internal().uploadCoverV1(request);
                    if (this.completeCallback != null) {
                        this.eventArgs.setFileId(this.fileId);
                        this.eventArgs.setPercentage(1.0);
                        this.completeCallback.callback(this.eventArgs);
                    }
                }
                finally {
                    IamUserTokenHolder.clearContext();
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public ICoverGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

