/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.util;

import com.digiwin.dap.middleware.dmc.common.utils.IOUtils;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestUtil {
    public static <T> T uploadFile(String url, Map<String, String> heads, InputStream inputStream, Class<T> entityClass) {
        DataInputStream in;
        DataOutputStream out;
        block5: {
            T t;
            out = null;
            in = null;
            try {
                URL realUrl = new URL(url);
                HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
                HttpRequestUtil.setHeader(heads, conn);
                conn.setRequestProperty("Content-Type", "application/octet-stream");
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                out = new DataOutputStream(conn.getOutputStream());
                in = new DataInputStream(inputStream);
                byte[] bufferOut = new byte[1024];
                int bytes = 0;
                while ((bytes = in.read(bufferOut)) != -1) {
                    ((OutputStream)out).write(bufferOut, 0, bytes);
                }
                ((OutputStream)out).flush();
                String result = HttpRequestUtil.getBody(conn);
                if (result.length() <= 0) break block5;
                t = ObjectMapperUtil.readValue(result, entityClass);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    HttpRequestUtil.closeStream(out, in);
                    throw throwable;
                }
            }
            HttpRequestUtil.closeStream(out, in);
            return t;
        }
        HttpRequestUtil.closeStream(out, in);
        return null;
    }

    public static void uploadSegFile(String url, Map<String, String> headers, int count, byte[] buf) {
        OutputStream out = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(headers, conn);
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            out = new DataOutputStream(conn.getOutputStream());
            out.write(buf, 0, count);
            out.flush();
            out.close();
            String result = HttpRequestUtil.getBody(conn);
            conn.disconnect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static OutputStream downloadFile(String url, Map<String, String> heads, OutputStream outputStream) {
        InputStream is = null;
        try {
            int count;
            URL realUrl = new URL(url);
            HttpURLConnection con = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(heads, con);
            con.setRequestMethod("GET");
            con.connect();
            HttpRequestUtil.errorHandler(con);
            is = con.getInputStream();
            byte[] buf = new byte[1024];
            while ((count = is.read(buf)) != -1) {
                outputStream.write(buf, 0, count);
            }
            outputStream.flush();
            OutputStream outputStream2 = outputStream;
            return outputStream2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void errorHandler(HttpURLConnection con) throws IOException {
        int code = con.getResponseCode();
        if (code != 200 && code != 201) {
            String error = IOUtils.readStreamAsString(con.getErrorStream(), StandardCharsets.UTF_8.name());
            if (error.length() > 0) {
                Map map = ObjectMapperUtil.readValue(error, HashMap.class);
                throw new OperateException(String.format("status code: %s ,detail: %s", code, map.get("message")));
            }
            throw new OperateException(String.format("status code: %s ,detail: %s", code, error));
        }
    }

    public static OutputStream downloadSegFile(String url, Map<String, String> headers, int chunk, OutputStream outputStream) {
        InputStream is = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection con = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(headers, con);
            con.setRequestMethod("GET");
            con.connect();
            HttpRequestUtil.errorHandler(con);
            is = con.getInputStream();
            HttpRequestUtil.writeFileOutputStream(chunk, is, outputStream);
            outputStream.flush();
            OutputStream outputStream2 = outputStream;
            return outputStream2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void writeFileOutputStream(int chunk, InputStream inStream, OutputStream outputStream) throws Exception {
        byte[] buffer = new byte[chunk];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        inStream.close();
    }

    public static <T> T get(String url, Map<String, String> heads, Class<T> entityClass) {
        try {
            URL realUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(heads, connection);
            connection.setRequestMethod("GET");
            connection.connect();
            String result = HttpRequestUtil.getBody(connection);
            connection.disconnect();
            if (result.length() > 0) {
                return ObjectMapperUtil.readValue(result, entityClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static byte[] getByte(String url, Map<String, String> heads) {
        InputStream is = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            URL realUrl = new URL(url);
            HttpURLConnection con = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(heads, con);
            con.setRequestMethod("GET");
            con.connect();
            is = con.getInputStream();
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T postJson(String url, String json, Map<String, String> heads, Class<T> entityClass) throws IOException {
        String result;
        OutputStreamWriter out = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(heads, conn);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            out.write(json);
            out.flush();
            result = HttpRequestUtil.getBody(conn);
            conn.disconnect();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (result.length() > 0) {
            return ObjectMapperUtil.readValue(result, entityClass);
        }
        return null;
    }

    public static <T> T delete(String url, Map<String, String> heads, Class<T> entityClass) {
        try {
            URL realUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(heads, connection);
            connection.setRequestMethod("DELETE");
            connection.connect();
            String result = HttpRequestUtil.getBody(connection);
            connection.disconnect();
            if (result != null && result.length() > 0) {
                return ObjectMapperUtil.readValue(result, entityClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static <T> T deleteJson(String url, String json, Map<String, String> heads, Class<T> entityClass) {
        OutputStreamWriter out = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(heads, conn);
            conn.setRequestMethod("DELETE");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(json);
            out.flush();
            String result = HttpRequestUtil.getBody(conn);
            conn.disconnect();
            if (result.length() > 0) {
                return ObjectMapperUtil.readValue(result, entityClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T put(String url, String json, Map<String, String> heads, Class<T> entityClass) throws IOException {
        String result;
        OutputStreamWriter out = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            HttpRequestUtil.setHeader(heads, conn);
            conn.setRequestMethod("PUT");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            out.write(json);
            out.flush();
            result = HttpRequestUtil.getBody(conn);
            conn.disconnect();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (result.length() > 0) {
            return ObjectMapperUtil.readValue(result, entityClass);
        }
        return null;
    }

    private static void closeStream(OutputStream os, InputStream is) {
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setHeader(Map<String, String> headers, URLConnection conn) {
        conn.setRequestProperty("accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("connection", "keep-alive");
        conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        for (Map.Entry<String, String> item : headers.entrySet()) {
            if (item.getValue() == null) continue;
            conn.addRequestProperty(item.getKey(), item.getValue());
        }
    }

    private static String getBody(HttpURLConnection connection) {
        BufferedReader in = null;
        try {
            String temp;
            StringBuffer resultBuffer = new StringBuffer();
            int code = connection.getResponseCode();
            in = code == 200 ? new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
            while ((temp = in.readLine()) != null) {
                resultBuffer.append(temp);
            }
            if (code != 200) {
                if (resultBuffer.length() > 0) {
                    Map map = ObjectMapperUtil.readValue(resultBuffer.toString(), HashMap.class);
                    throw new OperateException(String.format("status code: %s ,detail: %s", code, map.get("message")));
                }
                throw new OperateException(String.format("status code: %s ,detail: %s", code, resultBuffer.toString()));
            }
            String string = resultBuffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T postJson(String url, String json, Class<T> entityClass) throws IOException {
        String result;
        OutputStreamWriter out = null;
        try {
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("connection", "keep-alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            out.write(json);
            out.flush();
            result = HttpRequestUtil.getBody(conn);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (result.length() > 0) {
            return ObjectMapperUtil.readValue(result, entityClass);
        }
        return null;
    }
}

