/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.common.comm;

import com.digiwin.dap.middleware.dwpay.ClientConfiguration;
import com.digiwin.dap.middleware.dwpay.ClientException;
import com.digiwin.dap.middleware.dwpay.ServiceException;
import com.digiwin.dap.middleware.dwpay.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestHandler;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseHandler;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dwpay.common.utils.CodingUtils;
import com.digiwin.dap.middleware.dwpay.common.utils.DwPayUtils;
import com.digiwin.dap.middleware.dwpay.internal.DwPayConfig;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceClient {
    protected static final Logger logger = LoggerFactory.getLogger(ServiceClient.class);
    protected ClientConfiguration clientConfig;

    protected ServiceClient(ClientConfiguration clientConfig) {
        this.clientConfig = clientConfig;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    protected abstract ResponseMessage sendRequestCore(RequestMessage var1, ExecutionContext var2) throws IOException;

    public abstract DwPayConfig getConfig();

    public abstract void shutdown();

    public String getConnectionPoolStats() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request, ExecutionContext context) throws ServiceException, ClientException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(context, "context");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request, context);
            return responseMessage;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException ex) {
                logger.error("Unexpected io exception when trying to close http request: ", (Throwable)ex);
                throw new ClientException("Unexpected io exception when trying to close http request: ", ex);
            }
        }
    }

    public ResponseMessage sendRequestImpl(RequestMessage request, ExecutionContext context) throws ServiceException, ClientException {
        ResponseMessage response = null;
        try {
            this.handleRequest(request, context.getRequestHandlers());
            response = this.sendRequestCore(request, context);
            this.handleResponse(response, context.getResponseHandlers());
            return response;
        }
        catch (ServiceException sex) {
            logger.error("[Server]Unable to execute HTTP request: ", (Throwable)sex);
            this.closeResponseSilently(response);
            throw sex;
        }
        catch (ClientException cex) {
            logger.error("[Client]Unable to execute HTTP request: ", (Throwable)cex);
            this.closeResponseSilently(response);
            throw cex;
        }
        catch (Exception ex) {
            logger.error("[Unknown]Unable to execute HTTP request: ", (Throwable)ex);
            this.closeResponseSilently(response);
            throw new ClientException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getFormattedString("ConnectionError", ex.getMessage()), ex);
        }
    }

    private void handleRequest(RequestMessage message, List<RequestHandler> requestHandlers) throws ServiceException, ClientException {
        for (RequestHandler h : requestHandlers) {
            h.handle(message);
        }
    }

    private void handleResponse(ResponseMessage response, List<ResponseHandler> responseHandlers) throws ServiceException, ClientException {
        for (ResponseHandler h : responseHandlers) {
            h.handle(response);
        }
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

