/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.internal;

import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dwpay.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dwpay.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.dwpay.common.parser.ResponseParser;
import com.digiwin.dap.middleware.dwpay.common.utils.DwPayUtils;
import com.digiwin.dap.middleware.dwpay.internal.model.StdDataEncrypt;
import com.digiwin.dap.middleware.dwpay.model.TradeInfo;
import com.digiwin.dap.middleware.dwpay.model.TradeResult;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;

public final class ResponseParsers {
    public static final TradePayResponseParser tradePayResponseParser = new TradePayResponseParser();
    public static final TradeQueryResponseParser tradeQueryResponseParses = new TradeQueryResponseParser();
    public static final TradeCloseResponseParser tradeCloseResponseParser = new TradeCloseResponseParser();
    public static final TradeMqgResponseParser tradeMqgResponseParser = new TradeMqgResponseParser();
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public static final class TradeMqgResponseParser
    implements ResponseParser<TradeResult> {
        @Override
        public TradeResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                TradeResult result;
                TradeResult tradeResult = result = (TradeResult)objectMapper.readValue(response.getContent(), TradeResult.class);
                return tradeResult;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DwPayUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class TradeCloseResponseParser
    implements ResponseParser<TradeResult> {
        @Override
        public TradeResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdDataEncrypt result = (StdDataEncrypt)objectMapper.readValue(response.getContent(), StdDataEncrypt.class);
                TradeResult tradeResult = new TradeResult();
                tradeResult.setCode(result.getCode());
                tradeResult.setSuccess(result.isSuccess());
                tradeResult.setMessage(result.getMessage());
                if (StrUtils.isNotEmpty((String)((String)result.getData()))) {
                    String data = AES.decryptIvCBC((String)((String)result.getData()), (String)response.getAppSecret());
                    tradeResult.setData(data);
                }
                TradeResult tradeResult2 = tradeResult;
                return tradeResult2;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DwPayUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class TradeQueryResponseParser
    implements ResponseParser<TradeInfo> {
        @Override
        public TradeInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdDataEncrypt result = (StdDataEncrypt)objectMapper.readValue(response.getContent(), StdDataEncrypt.class);
                if (StrUtils.isNotEmpty((String)((String)result.getData()))) {
                    String data = AES.decryptIvCBC((String)((String)result.getData()), (String)response.getAppSecret());
                    TradeInfo tradeInfo = (TradeInfo)objectMapper.readValue(data, TradeInfo.class);
                    return tradeInfo;
                }
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DwPayUtils.safeCloseResponse(response);
            }
            return null;
        }
    }

    public static final class TradePayResponseParser
    implements ResponseParser<TradeResult> {
        @Override
        public TradeResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdDataEncrypt result = (StdDataEncrypt)objectMapper.readValue(response.getContent(), StdDataEncrypt.class);
                TradeResult tradeResult = new TradeResult();
                tradeResult.setCode(result.getCode());
                tradeResult.setSuccess(result.isSuccess());
                tradeResult.setMessage(result.getMessage());
                if (StrUtils.isNotEmpty((String)((String)result.getData()))) {
                    String data = AES.decryptIvCBC((String)((String)result.getData()), (String)response.getAppSecret());
                    tradeResult.setData(data);
                }
                TradeResult tradeResult2 = tradeResult;
                return tradeResult2;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DwPayUtils.safeCloseResponse(response);
            }
        }
    }
}

