/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.common.utils;

import com.digiwin.dap.middleware.dwpay.common.utils.DwPayUtils;
import java.util.List;

public class CodingUtils {
    public static void assertParameterNotNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getFormattedString("ParameterIsNull", paramName));
        }
    }

    public static void assertParameterInRange(long param, long lower, long upper) {
        if (!CodingUtils.checkParamRange(param, lower, true, upper, true)) {
            throw new IllegalArgumentException(String.format("%d not in valid range [%d, %d]", param, lower, upper));
        }
    }

    public static void assertStringNotNullOrEmpty(String param, String paramName) {
        CodingUtils.assertParameterNotNull(param, paramName);
        if (param.trim().length() == 0) {
            throw new IllegalArgumentException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getFormattedString("ParameterStringIsEmpty", paramName));
        }
    }

    public static void assertListNotNullOrEmpty(List<?> param, String paramName) {
        CodingUtils.assertParameterNotNull(param, paramName);
        if (param.size() == 0) {
            throw new IllegalArgumentException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getFormattedString("ParameterListIsEmpty", paramName));
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean checkParamRange(long param, long from, boolean leftInclusive, long to, boolean rightInclusive) {
        if (leftInclusive && rightInclusive) {
            return from <= param && param <= to;
        }
        if (leftInclusive && !rightInclusive) {
            return from <= param && param < to;
        }
        if (!leftInclusive && !rightInclusive) {
            return from < param && param < to;
        }
        return from < param && param <= to;
    }
}

