/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.internal;

import com.digiwin.dap.middleware.dwpay.DwPayException;
import com.digiwin.dap.middleware.dwpay.common.utils.DwPayUtils;
import java.net.URI;

public class DwPayConfig {
    private static final String PAY = "%s/api/dwpay/trade/pay";
    private static final String QUERY = "%s/api/dwpay/trade/query";
    private static final String CLOSE = "%s/api/dwpay/trade/close";
    private static final String MPG_ALTER_STATUS = "%s/api/dwpay/trade/mpg/period/alter/status";
    private String uri;
    private String appToken;
    private String appSecret;

    public static void check(DwPayConfig config) {
        if (config == null) {
            throw new DwPayException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getString("dwpay.sdk.config.null"));
        }
        if (config.getUri() == null) {
            throw new DwPayException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getString("dwpayc.sdk.config.uri.null"));
        }
        if (config.getAppToken() == null) {
            throw new DwPayException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getString("dwpay.sdk.config.appToken.null"));
        }
        if (config.getAppSecret() == null) {
            throw new DwPayException(DwPayUtils.DW_PAY_RESOURCE_MANAGER.getString("dwpay.sdk.config.appSecret.null"));
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public URI getPayUri() {
        return URI.create(String.format(PAY, this.uri));
    }

    public URI getQueryUri() {
        return URI.create(String.format(QUERY, this.uri));
    }

    public URI getCloseUri() {
        return URI.create(String.format(CLOSE, this.uri));
    }

    public URI getMpgAlterStatusUri() {
        return URI.create(String.format(MPG_ALTER_STATUS, this.uri));
    }
}

