/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dwpay.internal;

import com.digiwin.dap.middleware.dwpay.HttpMethod;
import com.digiwin.dap.middleware.dwpay.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dwpay.internal.model.GenericRequest;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;

public class DwPayRequestMessageBuilder {
    private URI endpoint;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpEntity entity;
    private boolean forceRetry;
    private GenericRequest originalRequest;
    private String appSecret;

    public static DwPayRequestMessageBuilder create() {
        return new DwPayRequestMessageBuilder();
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public DwPayRequestMessageBuilder setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public DwPayRequestMessageBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public DwPayRequestMessageBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public DwPayRequestMessageBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public DwPayRequestMessageBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public DwPayRequestMessageBuilder setForceRetry(boolean forceRetry) {
        this.forceRetry = forceRetry;
        return this;
    }

    public DwPayRequestMessageBuilder setOriginalRequest(GenericRequest originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public DwPayRequestMessageBuilder setAppSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public RequestMessage build() {
        RequestMessage request = new RequestMessage(this.originalRequest);
        request.setEndpoint(this.endpoint);
        request.setMethod(this.method);
        request.setHeaders(this.headers);
        request.setHttpEntity(this.entity);
        request.setForceRetry(this.forceRetry);
        request.setAppSecret(this.appSecret);
        return request;
    }
}

