package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.comm.HttpDeleteWithBody;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.http.client.HttpMethod;
import com.digiwin.dap.middleware.lmc.http.utils.HttpHeaders;
import com.digiwin.dap.middleware.lmc.internal.LmcConstant;
import org.apache.http.client.methods.*;

import java.net.URI;
import java.util.Map.Entry;

class HttpRequestFactory {

    public HttpRequestBase createHttpRequest(RequestMessage request) {
        URI uri = request.getEndpoint();

        HttpRequestBase httpRequest;
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            postMethod.setEntity(request.getHttpEntity());

            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            putMethod.setEntity(request.getHttpEntity());
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            if (request.getHttpEntity() != null) {
                HttpDeleteWithBody deleteMethod = new HttpDeleteWithBody(uri);
                deleteMethod.setEntity(request.getHttpEntity());
                httpRequest = deleteMethod;
            } else {
                httpRequest = new HttpDelete(uri);
            }
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        configureRequestHeaders(request, httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpRequestBase httpRequest) {
        for (Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase(HttpHeaders.CONTENT_LENGTH)
                    || entry.getKey().equalsIgnoreCase(HttpHeaders.HOST)) {
                continue;
            }
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }

        // Set content type and encoding
        if (httpRequest.getHeaders(HttpHeaders.CONTENT_TYPE) == null ||
                httpRequest.getHeaders(HttpHeaders.CONTENT_TYPE).length == 0){
            httpRequest.addHeader(HttpHeaders.CONTENT_TYPE,
                    "application/x-www-form-urlencoded; " +
                            "charset=" + LmcConstant.DEFAULT_CHARSET_NAME.toLowerCase());
        }
    }
}
