package com.digiwin.dap.middleware.lmc.request;

import java.io.Serializable;

/**
 * 功能描述
 *
 * @author chenzhuang
 * @date 2021/5/14 9:48
 */
public class BaseOpLog implements Serializable {
    private static final long serialVersionUID = 3999642539218429181L;
    /** 应用Id */
    private String appId;
    /** 模组id */
    private String moduleId;
    /** 行为Id */
    private String actId;
    /** 操作类型（update,delete,insert等） */
    private String operationType;
    /** 模板值 */
    private String template;
    /** 操作对象 */
    private String operationObject;


    /** 来源 CAC/GMC/OMC */
    private String source;
    /** 操作动作 */
    private String actionId;
    /** 主表主键 */
    private String primaryKey;
    /** 主表主键名称 */
    private String primaryName;
    /** 变更来源  */
    private String editPlace;
    /** 租户Id */
    private String tenantId;
    /** 租户名称 */
    private String tenantName;
    /** 修改原因 */
    private String remark;

    public BaseOpLog() {
    }

    public BaseOpLog(String appId, String moduleId, String actId, String operationType, String template, String tenantId,
                     String tenantName, String primaryKey, String primaryName, String remark) {
        this.appId = appId;
        this.moduleId = moduleId;
        this.actId = actId;
        this.operationType = operationType;
        this.template = template;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.primaryKey = primaryKey;
        this.primaryName = primaryName;
        this.remark = remark;
    }

    public BaseOpLog(String appId, String moduleId, String actId, String operationType, String template, String operationObject, String source, String actionId, String primaryKey, String primaryName, String editPlace, String tenantId, String tenantName, String remark) {
        this.appId = appId;
        this.moduleId = moduleId;
        this.actId = actId;
        this.operationType = operationType;
        this.template = template;
        this.operationObject = operationObject;
        this.source = source;
        this.actionId = actionId;
        this.primaryKey = primaryKey;
        this.primaryName = primaryName;
        this.editPlace = editPlace;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.remark = remark;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getModuleId() {
        return moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getActId() {
        return actId;
    }

    public void setActId(String actId) {
        this.actId = actId;
    }

    public String getOperationType() {
        return operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getPrimaryName() {
        return primaryName;
    }

    public void setPrimaryName(String primaryName) {
        this.primaryName = primaryName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOperationObject() {
        return operationObject;
    }

    public void setOperationObject(String operationObject) {
        this.operationObject = operationObject;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getEditPlace() {
        return editPlace;
    }

    public void setEditPlace(String editPlace) {
        this.editPlace = editPlace;
    }
}
