package com.digiwin.dap.middleware.lmc.request;

/**
 * 操作日志DTO
 *
 * @author chenzhuang
 * @date 2021/3/9 14:44
 */
public class OpLogDTO{
    /** 应用Id */
    private String appId;
    /** 模组id */
    private String moduleId;
    /** 行为Id */
    private String actId;
    /** 操作类型（update,delete,insert等） */
    private String operationType;
    /** 租户Id */
    private String tenantId;
    /** 租户名称 */
    private String tenantName;
    /** 主表主键 */
    private String primaryKey;
    /** 主表主键名称 */
    private String primaryName;
    /** 修改人 */
    private String modifyById;
    /** 创建人 */
    private String createById;
    /** 操作对象 */
    private String operationObject;

    /** 创建时间开始 例如 2020-03-01 00:00:00 */
    private String createDateStart;
    /** 创建时间结束 例如 2020-03-01 00:00:00 */
    private String createDateEnd;

    public OpLogDTO() {
    }

    public OpLogDTO(String appId, String moduleId, String actId, String operationType, String tenantId, String tenantName, String modifyById, String createDateStart, String createDateEnd) {
        this.appId = appId;
        this.moduleId = moduleId;
        this.actId = actId;
        this.operationType = operationType;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.modifyById = modifyById;
        this.createDateStart = createDateStart;
        this.createDateEnd = createDateEnd;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getModuleId() {
        return moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getActId() {
        return actId;
    }

    public void setActId(String actId) {
        this.actId = actId;
    }

    public String getOperationType() {
        return operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getModifyById() {
        return modifyById;
    }

    public void setModifyById(String modifyById) {
        this.modifyById = modifyById;
    }

    public String getCreateDateStart() {
        return createDateStart;
    }

    public void setCreateDateStart(String createDateStart) {
        this.createDateStart = createDateStart;
    }

    public String getCreateDateEnd() {
        return createDateEnd;
    }

    public void setCreateDateEnd(String createDateEnd) {
        this.createDateEnd = createDateEnd;
    }

    public String getPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getPrimaryName() {
        return primaryName;
    }

    public void setPrimaryName(String primaryName) {
        this.primaryName = primaryName;
    }

    public String getCreateById() {
        return createById;
    }

    public void setCreateById(String createById) {
        this.createById = createById;
    }

    public String getOperationObject() {
        return operationObject;
    }

    public void setOperationObject(String operationObject) {
        this.operationObject = operationObject;
    }

    @Override
    public String toString() {
        return "OpLogDTO{" +
                "appId='" + appId + '\'' +
                ", moduleId='" + moduleId + '\'' +
                ", actId='" + actId + '\'' +
                ", operationType='" + operationType + '\'' +
                ", tenantId='" + tenantId + '\'' +
                ", tenantName='" + tenantName + '\'' +
                ", primaryKey='" + primaryKey + '\'' +
                ", primaryName='" + primaryName + '\'' +
                ", modifyById='" + modifyById + '\'' +
                ", createById='" + createById + '\'' +
                ", operationObject='" + operationObject + '\'' +
                ", createDateStart='" + createDateStart + '\'' +
                ", createDateEnd='" + createDateEnd + '\'' +
                '}';
    }
}
