package com.digiwin.dap.middleware.lmc.request;

import java.util.Map;

/**
 * 分页查询请求
 *
 * @author chenzhuang
 * @date 2021/5/12 21:51
 */
public class PageOpLogRequest extends PageRequest {
    private static final long serialVersionUID = -3073834810947275358L;
    /**
     * 操作日志查询条件DTO
     *
     * <p>
     * appId必填
     * 例如：
     * {"appId":"应用id","moduleId":"模组id","actId":"行为id","operationType":"update,delete,insert等", "tenantId": "",
     * "tenantName": "","primaryKey":"","primaryName":"主键名称", "modifyById": "陈壮","createById":"chenzhuang",
     * "createDateStart": "2020-03-01 00:00:00", "createDateEnd": "2020-04-01 00:00:00"}
     */
    private OpLogDTO opLogDTO;

    public PageOpLogRequest() {
    }

    public PageOpLogRequest(OpLogDTO opLogDTO, Integer pageNum, Integer pageSize, Map<String, Object> orders) {
        super(pageNum, pageSize, orders);
        this.opLogDTO = opLogDTO;
    }

    public OpLogDTO getOpLogDTO() {
        return opLogDTO;
    }

    public void setOpLogDTO(OpLogDTO opLogDTO) {
        this.opLogDTO = opLogDTO;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.opLogDTO != null) {
            addObjectParams(this.opLogDTO);
        }
        return super.getParameters();
    }
}
