package com.digiwin.dap.middleware.lmc.request;

import com.digiwin.dap.middleware.lmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

/**
 * 功能描述
 *
 * @author chenzhuang
 * @date 2021/5/14 9:48
 */
public class SaveEventLogRequest extends GenericRequest {
    private static final long serialVersionUID = 4657226431041762753L;
    private SaveEventLog saveEventLog;

    public SaveEventLogRequest() {
    }

    public SaveEventLogRequest(SaveEventLog saveEventLog) {
        this.saveEventLog = saveEventLog;
    }

    public SaveEventLog getSaveEventLog() {
        return saveEventLog;
    }

    public void setSaveEventLog(SaveEventLog saveEventLog) {
        this.saveEventLog = saveEventLog;
    }

    @Override
    public HttpEntity getEntity() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValueAsString(this.saveEventLog))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
