package com.digiwin.dap.middleware.lmc.appender;

import com.digiwin.dap.middleware.lmc.internal.LmcConstant;
import com.digiwin.dap.middleware.lmc.util.CryptoUtil;
import com.digiwin.dap.middleware.lmc.util.LogUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * MongoLog4j2Appender
 *
 * @deprecated 3.0.0.0以后废弃。
 *  和db耦合度过高，使用率不高。
 *
 * @author yanyn
 * @author chenzhuang
 */
@Deprecated
@Plugin(
        name = "DwMongoLog4j2Appender",
        category = "Core",
        elementType = "appender",
        printObject = true
)
public class DwMongoLog4j2Appender extends AbstractAppender {
    private static SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private MongoCollection<BasicDBObject> logsCollection;
    private List<String> tracerKeysList;
    private String connectionUrl;
    private String userName;
    private String password;
    private String databaseName = "lmc";
    private String collectionName;
    private String app;
    private String traceKeys;

    protected DwMongoLog4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout, String app, String databaseName, String collectionName, String server, String port, String userName, String password, String traceKeys) {
        super(name, filter, layout);
        if (userName != null && !"".equals(userName)) {
            if (password != null) {
                password = CryptoUtil.dapDecode(password);
            }
            this.setConnectionUrl("mongodb://" + userName + ":" + password + "@" + server + ":" + port);
        } else {
            this.setConnectionUrl("mongodb://" + server + ":" + port);
        }
        this.app = app;
        this.traceKeys = traceKeys;
        this.collectionName = (app + LmcConstant.SUFFIX_DEVLOG).toLowerCase();
    }

    @Override
    public void append(LogEvent event) {
        if (this.mongoDatabase == null) {
            MongoClientURI connectionString = new MongoClientURI(this.connectionUrl);
            this.mongoClient = new MongoClient(connectionString);
            this.mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            this.logsCollection = this.mongoDatabase.getCollection(this.collectionName, BasicDBObject.class);
        }
        Map<String, Object> logMap = new HashMap<>();

        Map<String, String> contextDataMap = event.getContextData().toMap();
        String traceId;
        if (!contextDataMap.isEmpty()) {
            String ptxId = contextDataMap.get("PtxId");
            //String pspanId = contextDataMap.get("PspanId ");
            if (ptxId != null && !"".equals(ptxId)) {
                traceId = ptxId;
            } else {
                traceId = LogUtils.getUUID();
            }
        } else {
            traceId = LogUtils.getUUID();
        }
        logMap.putIfAbsent("traceId", traceId);

        Map<String, Object> initMap = new HashMap<>();
        LogUtils.initLogMap(initMap);
        logMap.putAll(initMap);
        logMap.putIfAbsent("appId", this.getApp());
        logMap.putIfAbsent("time", _sdf.format(new Date()));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("thread", event.getThreadName());

        logMap.putIfAbsent("loggerName", event.getLoggerName());
        String addr = LogUtils.getLocalHostIpName();
        logMap.putIfAbsent("source", addr);

        Message msg = event.getMessage();
        if (msg instanceof ObjectMessage) {
            logMap.putIfAbsent("appender", "DwMongoLog4j2Appender-map");
        } else {
            logMap.putIfAbsent("appender", "DwMongoLog4j2Appender-str");
        }

        StackTraceElement source = event.getSource();
        if (source == null && (!event.isIncludeLocation())) {
            event.setIncludeLocation(true);
            source = event.getSource();
            event.setIncludeLocation(false);
        }

        logMap.putIfAbsent("location", source == null ? "Unknown(Unknown Source)" : source.toString());

        String message = event.getMessage().getFormattedMessage();
        logMap.putIfAbsent("message", message);

        String throwable = getThrowableStr(event.getThrown());
        if (throwable != null) {
            logMap.putIfAbsent("throwable", throwable);
        }

        if (getLayout() != null) {
            logMap.putIfAbsent("log", new String(getLayout().toByteArray(event)));
        }

        BasicDBObject document = new BasicDBObject();
        document.putAll(logMap);
        this.logsCollection.insertOne(document);
    }

    @PluginFactory
    public static DwMongoLog4j2Appender createAppender(
            @PluginAttribute("name") String name,
            @PluginElement("Filter") final Filter filter,
            @PluginElement("Layout") Layout<? extends Serializable> layout,

            @PluginAttribute("app") String app,

            @PluginAttribute("databaseName") String databaseName,
            @PluginAttribute("collectionName") String collectionName,
            @PluginAttribute("server") String server,
            @PluginAttribute("port") String port,
            @PluginAttribute("userName") String userName,
            @PluginAttribute("password") String password,
            @PluginAttribute("traceKeys") String traceKeys) {
        if (name == null) {
            LOGGER.error("no name defined in conf.");
            return null;
        }
        if (app == null) {
            LOGGER.error("no app defined in conf.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (server == null) {
            server = "127.0.0.1";
        }
        if (isStrEmpty(port)) {
            port = "27017";
        }
        return new DwMongoLog4j2Appender(name, filter, (Layout) layout, app, databaseName, collectionName, server, port, userName, password, traceKeys);
    }

    static boolean isStrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getTraceKeys() {
        return this.traceKeys;
    }

    public void setTraceKeys(String traceKeys) {
        if (traceKeys != null && !"".equals(traceKeys)) {
            this.traceKeys = traceKeys;
            this.tracerKeysList = (List) Stream.of(traceKeys.split(",")).map(String::trim).collect(Collectors.toList());
        }

    }

    private String getThrowableStr(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String s : Throwables.toStringList(throwable)) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(s);
        }
        return sb.toString();
    }
}
