package com.digiwin.dap.middleware.lmc.http.client;

/**
 * httpclient config
 *
 * @author ChenZhuang
 * @date 2022/12/4 20:26:34
 */
public class HttpConfig {
    /** 建立连接的超时连接 */
    public static final int CONNECT_TIMEOUT = 5000;
    /** 等待连接池返回可用连接的超时时间 */
    public static final int CONNECT_REQUEST_TIMEOUT = 5000;
    /** 服务器读超时时间 */
    public static final int SOCKET_TIMEOUT = 5000;
    /** 整个连接池最大连接数，默认20 */
    public static final int MAX_TOTAL_CONNECTIONS = 4;
    /** 设置每个路由的最大并发连接数,默认为2 */
    public static final int MAXIMUM_CONNECTION_PER_ROUTE = 4;
    /** keep-alive */
    public static final int DEFAULT_KEEP_ALIVE_TIME_MILLIS = 20 * 1000;
    /** 链接空闲时间,默认2s */
    public static final int CONNECTION_VALIDATE_AFTER_INACTIVITY_MS = 2 * 1000;
    /** 空闲连接释放时间（秒） */
    public static final int CLOSE_IDLE_CONNECTION_WAIT_TIME_SECS = 30;

}