package com.digiwin.dap.middleware.lmc.internal;

/**
 * 业务操作类型:（0其他,1查询,2新增,3修改,4删除,5授权,6导入,7导出,8登入,9登出,10清空数据）
 *
 * @author chengzhuang
 */
public enum BusinessTypeEnum {
    /**
     * 业务操作类型：0其它
     */
    OTHER(0, "其他", "other"),
    /**
     * 业务操作类型：1查询
     */
    QUERY(1, "查询", "query"),
    /**
     * 业务操作类型：2新增
     */
    INSERT(2, "新增", "insert"),
    /**
     * 业务操作类型：3修改
     */
    UPDATE(3, "修改", "update"),
    /**
     * 业务操作类型：4删除
     */
    DELETE(4, "删除", "delete"),
    /**
     * 业务操作类型：5授权
     */
    GRANT(5, "授权", "grant"),
    /**
     * 业务操作类型：6导入
     */
    IMPORT(6, "导入", "import"),
    /**
     * 业务操作类型：7导出
     */
    EXPORT(7, "导出", "export"),
    /**
     * 业务操作类型：8登入
     */
    LOGIN(8, "登入", "login"),
    /**
     * 业务操作类型：9登出
     */
    LOGOUT(9, "登出", "logout"),
    /**
     * 业务操作类型：10清空数据
     */
    CLEAN(10, "清空数据", "clean");

    private final Integer value;
    private final String name;
    private final String describe;

    BusinessTypeEnum(Integer value, String name, String describe) {
        this.value = value;
        this.name = name;
        this.describe = describe;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getDescribe() {
        return this.describe;
    }

    public static String getName(Integer val) {
        if (val == null) {
            return "";
        }
        for (BusinessTypeEnum objEnum : BusinessTypeEnum.values()) {
            if (objEnum.getValue().equals(val)) {
                return objEnum.name;
            }
        }
        return "";
    }

    public static String getDescribe(Integer val) {
        if (val == null) {
            return "";
        }
        for (BusinessTypeEnum objEnum : BusinessTypeEnum.values()) {
            if (objEnum.getValue().equals(val)) {
                return objEnum.describe;
            }
        }
        return "";
    }

    public static boolean contains(Integer val) {
        for (BusinessTypeEnum objEnum : BusinessTypeEnum.values()) {
            if (objEnum.getValue().equals(val)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "BusinessTypeEnum{" +
                "value=" + value +
                ", name='" + name + '\'' +
                ", describe='" + describe + '\'' +
                '}';
    }
}
