package com.digiwin.dap.middleware.lmc.request;

import java.util.List;
import java.util.Map;

/**
 * 事件日志DTO
 *
 * @author chenzhuang
 * @date 2021/3/24 14:18
 */
public class EventLogDTO extends BaseDTO{
    /** 应用Id */
    private String appId;
    /** 事件id */
    private String eventId;
    /** 事件名称 */
    private String eventName;
    /** 事件类型 （0其他,1查询,2新增,3修改,4删除,5授权,6导入,7导出,8登入,9登出,10清空数据）*/
    private Integer eventType;
    /** 租户id */
    private String tenantId;
    /** 应用id */
    private String sysId;
    /** 操作人Id */
    private String userId;
    /** 事件来源 */
    private String eventSource;
    /** 事件自定义信息 */
    private Map<String,Object> content;

    /** 创建时间开始 例如 2020-03-01 00:00:00 */
    private String createDateStart;
    /** 创建时间结束 例如 2020-03-01 00:00:00 */
    private String createDateEnd;
    /** 操作人员id或name */
    private String userContent;
    /** 租户id或name */
    private String tenantContent;
    /** 应用id或name */
    private String sysContent;
    /** 事件类型集合 */
    private List<Integer> eventTypes;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventSource() {
        return eventSource;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public Integer getEventType() {
        return eventType;
    }

    public void setEventType(Integer eventType) {
        this.eventType = eventType;
    }

    public String getUserContent() {
        return userContent;
    }

    public void setUserContent(String userContent) {
        this.userContent = userContent;
    }

    public String getCreateDateStart() {
        return createDateStart;
    }

    public void setCreateDateStart(String createDateStart) {
        this.createDateStart = createDateStart;
    }

    public String getCreateDateEnd() {
        return createDateEnd;
    }

    public void setCreateDateEnd(String createDateEnd) {
        this.createDateEnd = createDateEnd;
    }

    public String getEventId() {
        return eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, Object> getContent() {
        return content;
    }

    public void setContent(Map<String, Object> content) {
        this.content = content;
    }

    public String getTenantContent() {
        return tenantContent;
    }

    public void setTenantContent(String tenantContent) {
        this.tenantContent = tenantContent;
    }

    public String getSysId() {
        return sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getSysContent() {
        return sysContent;
    }

    public void setSysContent(String sysContent) {
        this.sysContent = sysContent;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<Integer> getEventTypes() {
        return eventTypes;
    }

    public void setEventTypes(List<Integer> eventTypes) {
        this.eventTypes = eventTypes;
    }
}
