package com.digiwin.dap.middleware.lmc.request;

import com.digiwin.dap.middleware.lmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.lmc.internal.model.ModifiedInfo;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

/**
 * 比对的变更历程
 *
 * @author chenzhuang
 * @date 2021/5/12 18:34
 */
public class ModifiedInfoRequest extends GenericRequest {
    private static final long serialVersionUID = 1304204675569810199L;
    private ModifiedInfo modifiedInfo;

    public ModifiedInfoRequest() {
    }

    public ModifiedInfoRequest(ModifiedInfo modifiedInfo) {
        this.modifiedInfo = modifiedInfo;
    }

    public ModifiedInfo getModifiedInfo() {
        return modifiedInfo;
    }

    public void setModifiedInfo(ModifiedInfo modifiedInfo) {
        this.modifiedInfo = modifiedInfo;
    }

    @Override
    public HttpEntity getEntity() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValueAsString(modifiedInfo))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
