package com.digiwin.dap.middleware.lmc.request;

import java.util.List;
import java.util.Map;

/**
 * 操作日志DTO
 *
 * @author chenzhuang
 * @date 2021/3/9 14:44
 */
public class OpLogDTO extends BaseDTO{
    /** 应用Id */
    private String appId;
    /** 模组id */
    private String moduleId;
    /** 行为Id */
    private String actId;
    /** 操作类型（update,delete,insert等） */
    private String operationType;
    /** 操作对象 */
    private String operationObject;

    /** 来源 CAC/GMC/OMC */
    private String source;
    /** 操作动作 UPDATE/INSERT/DELETE */
    private String actionId;
    /** 租户Id */
    private String tenantId;
    /** 租户名称 */
    private String tenantName;
    /** 主表主键 */
    private String primaryKey;
    /** 主表主键名称 */
    private String primaryName;
    /** 变更来源  */
    private String editPlace;
    /** 修改人id */
    private String editUserId;
    /** 修改时间 */
    private String editTime;
    /** 修改人 */
    private String modifyById;
    /** 创建人 */
    private String createById;
    /** 自定义信息 */
    private Map<String,Object> content;

    /** 修改时间 */
    private String beginTime;
    private String endTime;
    /** 创建时间开始 例如 2020-03-01 00:00:00 */
    private String createDateStart;
    /** 创建时间结束 例如 2020-03-01 00:00:00 */
    private String createDateEnd;
    /** 变更事项 */
    private List<String> actionIds;
    /** not in 创建人Id集合 */
    private List<String> notInCreateByIds;
    /** not in 来源 */
    private List<String> notInSources;
    /** 租户id或name */
    private String tenantContent;

    public OpLogDTO() {
    }

    public OpLogDTO(String appId, String moduleId, String actId, String operationType, String tenantId, String tenantName, String modifyById, String createDateStart, String createDateEnd) {
        this.appId = appId;
        this.moduleId = moduleId;
        this.actId = actId;
        this.operationType = operationType;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.modifyById = modifyById;
        this.createDateStart = createDateStart;
        this.createDateEnd = createDateEnd;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getModuleId() {
        return moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getActId() {
        return actId;
    }

    public void setActId(String actId) {
        this.actId = actId;
    }

    public String getOperationType() {
        return operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getModifyById() {
        return modifyById;
    }

    public void setModifyById(String modifyById) {
        this.modifyById = modifyById;
    }

    public String getCreateDateStart() {
        return createDateStart;
    }

    public void setCreateDateStart(String createDateStart) {
        this.createDateStart = createDateStart;
    }

    public String getCreateDateEnd() {
        return createDateEnd;
    }

    public void setCreateDateEnd(String createDateEnd) {
        this.createDateEnd = createDateEnd;
    }

    public String getPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getPrimaryName() {
        return primaryName;
    }

    public void setPrimaryName(String primaryName) {
        this.primaryName = primaryName;
    }

    public String getCreateById() {
        return createById;
    }

    public void setCreateById(String createById) {
        this.createById = createById;
    }

    public String getOperationObject() {
        return operationObject;
    }

    public void setOperationObject(String operationObject) {
        this.operationObject = operationObject;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getEditPlace() {
        return editPlace;
    }

    public void setEditPlace(String editPlace) {
        this.editPlace = editPlace;
    }

    public String getEditUserId() {
        return editUserId;
    }

    public void setEditUserId(String editUserId) {
        this.editUserId = editUserId;
    }

    public String getEditTime() {
        return editTime;
    }

    public void setEditTime(String editTime) {
        this.editTime = editTime;
    }

    public Map<String, Object> getContent() {
        return content;
    }

    public void setContent(Map<String, Object> content) {
        this.content = content;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public List<String> getActionIds() {
        return actionIds;
    }

    public void setActionIds(List<String> actionIds) {
        this.actionIds = actionIds;
    }

    public List<String> getNotInCreateByIds() {
        return notInCreateByIds;
    }

    public void setNotInCreateByIds(List<String> notInCreateByIds) {
        this.notInCreateByIds = notInCreateByIds;
    }

    public List<String> getNotInSources() {
        return notInSources;
    }

    public void setNotInSources(List<String> notInSources) {
        this.notInSources = notInSources;
    }

    public String getTenantContent() {
        return tenantContent;
    }

    public void setTenantContent(String tenantContent) {
        this.tenantContent = tenantContent;
    }

    @Override
    public String toString() {
        return "OpLogDTO{" +
                "appId='" + appId + '\'' +
                ", moduleId='" + moduleId + '\'' +
                ", actId='" + actId + '\'' +
                ", operationType='" + operationType + '\'' +
                ", operationObject='" + operationObject + '\'' +
                ", source='" + source + '\'' +
                ", actionId='" + actionId + '\'' +
                ", tenantId='" + tenantId + '\'' +
                ", tenantName='" + tenantName + '\'' +
                ", primaryKey='" + primaryKey + '\'' +
                ", primaryName='" + primaryName + '\'' +
                ", editPlace='" + editPlace + '\'' +
                ", editUserId='" + editUserId + '\'' +
                ", editTime='" + editTime + '\'' +
                ", modifyById='" + modifyById + '\'' +
                ", createById='" + createById + '\'' +
                ", content=" + content +
                ", beginTime='" + beginTime + '\'' +
                ", endTime='" + endTime + '\'' +
                ", createDateStart='" + createDateStart + '\'' +
                ", createDateEnd='" + createDateEnd + '\'' +
                ", actionIds=" + actionIds +
                ", notInCreateByIds=" + notInCreateByIds +
                ", notInSources=" + notInSources +
                ", tenantContent='" + tenantContent + '\'' +
                "} " + super.toString();
    }
}
