package com.digiwin.dap.middleware.lmc.request;

import com.digiwin.dap.middleware.lmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.lmc.internal.model.entity.OpLog;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

/**
 * 操作日志request
 *
 * @author chenzhuang
 * @date 2021/5/8 17:09
 */
public class OpLogRequest extends GenericRequest{

    private static final long serialVersionUID = -2858858524947753856L;
    private OpLog opLog;

    public OpLogRequest() {
    }

    public OpLogRequest(OpLog opLog) {
        this.opLog = opLog;
    }

    public OpLog getOpLog() {
        return opLog;
    }

    public void setOpLog(OpLog opLog) {
        this.opLog = opLog;
    }

    @Override
    public HttpEntity getEntity() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValueAsString(opLog))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
