package com.digiwin.dap.middleware.lmc.request;

import java.util.Map;

/**
 * 分页查询请求
 *
 * @author chenzhuang
 * @date 2021/5/12 21:51
 */
public class PageDevLogRequest extends PageRequest {
    private static final long serialVersionUID = -3367861128409005527L;
    /**
     * 操作日志查询条件DTO
     *
     * <p>
     * appId 必填
     * 例如：
     * 查询条件 例如{"appId":"应用id","level":"日志级别","appender":"行为id","loggerName":"日志来源类com.digiwin.dap.middleware.lmc.request.DevLogDTO",
     * "tenantId":"租户id","tenantContent":"租户id或者名称","message":"日志信息","log":"log全文搜索","source":"来源",
     * "timeStart":"2020-03-01 00:00:00.000","timeEnd":"2020-04-01 00:00:00.000"}
     */
    private DevLogDTO devLogDTO;

    public PageDevLogRequest() {
    }

    public PageDevLogRequest(DevLogDTO devLogDTO, Integer pageNum, Integer pageSize, Map<String, Object> orders) {
        super(pageNum, pageSize, orders);
        this.devLogDTO = devLogDTO;
    }


    public DevLogDTO getDevLogDTO() {
        return devLogDTO;
    }

    public void setDevLogDTO(DevLogDTO devLogDTO) {
        this.devLogDTO = devLogDTO;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.devLogDTO != null) {
            addObjectParams(this.devLogDTO);
        }
        return super.getParameters();
    }
}
