package com.digiwin.dap.middleware.lmc.util;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import java.security.Key;
import java.security.SecureRandom;

/**
 * DES加密解密工具类
 *
 * @Author: chenzhuang
 * @Date: 2021-5-21 17:32:25
 */
public class CryptoUtil {
    private static String key = "com.digiwin.dap.middleware";
    private static Key DEFAULT_KEY;
    /**
     * 默认密钥
     */
    private static final String DEFAULT_SECRET_KEY = "1qaz2wsx3edc$RFV%TGB^YHN&UJM";
    /**
     * 加密模式
     */
    private static final String DES = "DES";
    /**
     * 加密解密格式
     */
    private static final String format = "DES/ECB/PKCS5Padding";

    /**
     * 优先加载获得key
     */
    static {
        DEFAULT_KEY = obtainKey(DEFAULT_SECRET_KEY);
    }

    /**
     * 获得key
     **/
    private static Key obtainKey(String key) {
        //如果key等于null 使用默认密钥
        if (key == null) {
            return DEFAULT_KEY;
        }
        KeyGenerator generator = null;
        try {
            generator = KeyGenerator.getInstance(DES);
            //防止linux下 随机生成key
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes("UTF-8"));
            generator.init(secureRandom);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return generator.generateKey();
    }

    /**
     * null key 加密 使用默认密钥加密
     * String明文输入,String密文输出
     */
    public static String encode(String str) {
        return encode(null, str);
    }

    /**
     * 加密
     * String明文输入,String密文输出
     */
    public static String encode(String key, String str) {
        return Base64.encodeBase64URLSafeString(obtainEncode(key, str.getBytes()));
        // return Hex.encodeHexString(obtainEncode(key, str.getBytes()));
        // 可以转化为16进制数据
    }

    /**
     * null key 解密 使用默认密钥解密
     * 以String密文输入,String明文输出
     */
    public static String decode(String str) {
        return decode(null, str);
    }

    /**
     * 解密
     * 以String密文输入,String明文输出
     */
    public static String decode(String key, String str) {
        return new String(obtainDecode(key, Base64.decodeBase64(str)));
        // 可以转化为16进制的数据
//      try {
//          return new String(obtainDecode(key, Hex.decodeHex(str.toCharArray())));
//      } catch (DecoderException e) {
//          // TODO Auto-generated catch block
//          e.printStackTrace();
//      }
    }

    /**
     * 底层加密方法
     * 以byte[]明文输入,byte[]密文输出
     */
    private static byte[] obtainEncode(String key, byte[] str) {
        byte[] byteFina = null;
        Cipher cipher;
        try {
            Key key1 = obtainKey(key);
            cipher = Cipher.getInstance(format);
            cipher.init(Cipher.ENCRYPT_MODE, key1);
            byteFina = cipher.doFinal(str);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return byteFina;
    }

    /**
     * 底层解密方法
     * 以byte[]密文输入,以byte[]明文输出
     */
    private static byte[] obtainDecode(String key, byte[] str) {
        Cipher cipher;
        byte[] byteFina = null;
        try {
            Key key1 = obtainKey(key);
            cipher = Cipher.getInstance(format);
            cipher.init(Cipher.DECRYPT_MODE, key1);
            byteFina = cipher.doFinal(str);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return byteFina;
    }

    /**
     * dap解密
     */
    public static String dapDecode(String str) {
        return decode(key, str);
    }

    /**
     * dap加密
     */
    public static String dapEcode(String str) {
       return encode(key, str);
    }

    public static void main(String[] args) {
        //String key = "abc";
        //String content = "abc123";
        //System.out.println("加密前：" + content);
        //String a = CryptoUtil.encode(key, content);
        //System.out.println("加密后：" + a);
        //String b = CryptoUtil.decode(key, a);
        //System.out.println("解密后：" + b);
        //
        //String content2 = "root";
        //System.out.println("加密前：" + content2);
        //String a2 = CryptoUtil.dapEcode(content2);
        //System.out.println("加密后：" + a2);
        //String b2 = CryptoUtil.dapDecode(a2);
        //System.out.println("解密后：" + b2);
    }

}
