/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.appender;

import com.digiwin.dap.middleware.lmc.common.TimeingSingletonEnum;
import com.digiwin.dap.middleware.lmc.internal.LMCResourceUri;
import com.digiwin.dap.middleware.lmc.util.LogUtils;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.json.JSONArray;

@Plugin(name="DwLog4j2Appender", category="Core", elementType="appender", printObject=true)
public class DwLog4j2Appender
extends AbstractAppender {
    static final String PROPERTY_NAME_ASYNC_EVENT_ROUTER = "log4j2.AsyncQueueFullPolicy";
    static final String PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER = "Discard";
    public static final int PERIOD_MILL_SECONDS = 2000;
    private final SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final int QUEUE_SIZE = 50;
    private static final Queue<Map<String, Object>> QUEUE = new LinkedBlockingQueue<Map<String, Object>>(50);
    private CloseableHttpClient client;
    private String endpoint;
    private String app;
    private String userAgent = "log4j2";

    protected DwLog4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout, String endpoint, String app) {
        super(name, filter, layout);
        this.endpoint = endpoint;
        this.app = app;
    }

    public void start() {
        super.start();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(4);
        connectionManager.setDefaultMaxPerRoute(4);
        connectionManager.setValidateAfterInactivity(2000);
        this.client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        this.initProperties();
        this.initInsertQueueTask();
    }

    public void stop() {
        super.stop();
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public void append(LogEvent event) {
        String ptxId;
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        Map contextDataMap = event.getContextData().toMap();
        String traceId = !contextDataMap.isEmpty() ? ((ptxId = (String)contextDataMap.get("PtxId")) != null && !"".equals(ptxId) ? ptxId : LogUtils.getUUID()) : LogUtils.getUUID();
        logMap.putIfAbsent("traceId", traceId);
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        LogUtils.initLogMap(initMap);
        logMap.putAll(initMap);
        logMap.putIfAbsent("appId", this.getApp());
        logMap.putIfAbsent("time", this._sdf.format(new Date()));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("thread", event.getThreadName());
        logMap.putIfAbsent("loggerName", event.getLoggerName());
        String addr = LogUtils.getLocalHostIpName();
        logMap.putIfAbsent("source", addr);
        logMap.putIfAbsent("appender", "DwLog4j2Appender");
        StackTraceElement source = event.getSource();
        if (source == null && !event.isIncludeLocation()) {
            event.setIncludeLocation(true);
            source = event.getSource();
            event.setIncludeLocation(false);
        }
        logMap.putIfAbsent("location", source == null ? "Unknown(Unknown Source)" : source.toString());
        String message = event.getMessage().getFormattedMessage();
        logMap.putIfAbsent("message", message);
        String throwable = this.getThrowableStr(event.getThrown());
        if (throwable != null) {
            logMap.putIfAbsent("throwable", throwable);
        }
        if (this.getLayout() != null) {
            logMap.putIfAbsent("log", new String(this.getLayout().toByteArray(event)));
        }
        if (QUEUE.offer(logMap)) {
            return;
        }
        this.insertQueue(logMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertQueue(Map<String, Object> logMap) {
        if (logMap == null) {
            boolean executable;
            boolean bl = executable = System.currentTimeMillis() - TimeingSingletonEnum.getInstance().getExecutionTimeMs() > 2000L && !QUEUE.isEmpty();
            if (!executable) {
                return;
            }
        }
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>(QUEUE);
        QUEUE.clear();
        TimeingSingletonEnum.getInstance().setExecutionTimeMs(System.currentTimeMillis());
        Optional.ofNullable(logMap).ifPresent(QUEUE::offer);
        if (insertList.isEmpty()) {
            return;
        }
        CloseableHttpResponse hResponse = null;
        HttpPost postMethod = new HttpPost(LMCResourceUri.getSaveDevLogBatchUrl(this.endpoint));
        try {
            JSONArray tmepObjects = new JSONArray(insertList);
            String formatValue = tmepObjects.toString();
            postMethod.setEntity((HttpEntity)new StringEntity(formatValue, ContentType.APPLICATION_JSON));
            hResponse = this.client.execute((HttpUriRequest)postMethod);
            HttpEntity repEntity = hResponse.getEntity();
            int statusCode = hResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                postMethod.abort();
            }
        }
        catch (Exception e) {
            this.error(e.getMessage());
        }
        finally {
            if (hResponse != null) {
                try {
                    hResponse.close();
                }
                catch (IOException e) {
                    this.error(e.getMessage());
                }
            }
        }
    }

    private void initProperties() {
        if (PropertiesUtil.getProperties().getStringProperty(PROPERTY_NAME_ASYNC_EVENT_ROUTER) == null) {
            System.setProperty(PROPERTY_NAME_ASYNC_EVENT_ROUTER, PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER);
        }
    }

    private void initInsertQueueTask() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(() -> this.insertQueue(null), 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    private String getThrowableStr(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String s : Throwables.toStringList((Throwable)throwable)) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @PluginFactory
    public static DwLog4j2Appender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="endpoint") String endpoint, @PluginAttribute(value="app") String app) {
        if (name == null) {
            LOGGER.error("no name defined in conf.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new DwLog4j2Appender(name, filter, (Layout<? extends Serializable>)layout, endpoint, app);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public CloseableHttpClient getHttpClient() {
        return this.client;
    }

    public void setHttpClient(CloseableHttpClient client) {
        this.client = client;
    }
}

