/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.auth.AuthCache;
import com.digiwin.dap.middleware.lmc.common.auth.BasicAuthCache;
import com.digiwin.dap.middleware.lmc.common.comm.IdleConnectionReaper;
import com.digiwin.dap.middleware.lmc.http.client.ClientConfiguration;
import com.digiwin.dap.middleware.lmc.http.comm.HttpRequestFactory;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ServiceClient;
import com.digiwin.dap.middleware.lmc.http.utils.ExceptionFactory;
import com.digiwin.dap.middleware.lmc.http.utils.HttpUtil;
import com.digiwin.dap.middleware.lmc.http.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager;
    protected RequestConfig requestConfig;
    protected AuthCache authCache = new BasicAuthCache();
    private volatile String endpoint = "https://lmc-test.digiwincloud.com.cn";

    public DefaultServiceClient() {
        super(new ClientConfiguration());
        this.connectionManager = this.createHttpClientConnectionManager();
        this.httpClient = this.createHttpClient(this.connectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(this.config.getConnectionTimeout());
        requestConfigBuilder.setSocketTimeout(this.config.getSocketTimeout());
        requestConfigBuilder.setConnectionRequestTimeout(this.config.getConnectionRequestTimeout());
        this.requestConfig = requestConfigBuilder.build();
    }

    @Override
    public ResponseMessage sendRequestCore(RequestMessage request) throws IOException {
        CloseableHttpResponse httpResponse;
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request);
        HttpClientContext httpContext = this.createHttpContext();
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    private static ResponseMessage buildResponse(RequestMessage request, CloseableHttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage();
        response.setUrl(request.getEndpoint().toString());
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        if (httpResponse.getEntity() != null) {
            if (response.isSuccessful()) {
                response.setContent(httpResponse.getEntity().getContent());
            } else {
                DefaultServiceClient.readAndSetErrorResponse(httpResponse.getEntity().getContent(), response);
            }
        }
        for (Header header : httpResponse.getAllHeaders()) {
            if ("Content-Length".equalsIgnoreCase(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    private static void readAndSetErrorResponse(InputStream originalContent, ResponseMessage response) throws IOException {
        byte[] contentBytes = IOUtils.readStreamAsByteArray(originalContent);
        response.setErrorResponseAsString(new String(contentBytes));
        response.setContent(new ByteArrayInputStream(contentBytes));
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).disableContentCompression().disableAutomaticRetries().build();
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.config.getSocketTimeout()).build());
        if (this.config.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.config.getIdleConnectionTime());
            IdleConnectionReaper.registerConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    private HttpClientContext createHttpContext() {
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        return httpContext;
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    @Override
    public AuthCache getAuthCache() {
        return this.authCache;
    }

    @Override
    public void setAuthCache(String endpoint, String token) {
        this.endpoint = endpoint;
        this.authCache.put(endpoint, token);
    }
}

