/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.comm.HttpDeleteWithBody;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.http.client.HttpMethod;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public HttpRequestBase createHttpRequest(RequestMessage request) {
        Object httpRequest;
        URI uri = request.getEndpoint();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            postMethod.setEntity(request.getHttpEntity());
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            putMethod.setEntity(request.getHttpEntity());
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            if (request.getHttpEntity() != null) {
                HttpDeleteWithBody deleteMethod = new HttpDeleteWithBody(uri);
                deleteMethod.setEntity(request.getHttpEntity());
                httpRequest = deleteMethod;
            } else {
                httpRequest = new HttpDelete(uri);
            }
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        this.configureRequestHeaders(request, (HttpRequestBase)httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + "utf-8".toLowerCase());
        }
    }
}

