/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.util;

import com.digiwin.dap.middleware.lmc.util.LMCUtils;
import java.util.Collection;

public final class Args {
    private Args() {
    }

    public static void notNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException("[" + name + "] must not be null");
        }
    }

    public static void notNullOrEmpty(Collection collection, String name) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("[" + name + "] must not be null or empty!");
        }
    }

    public static void notNullOrEmpty(String value, String name) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("[" + name + "] must not be null or empty!");
        }
    }

    public static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkDuration(String duration) {
        Args.notNullOrEmpty(duration, "duration");
        try {
            LMCUtils.parseDuration(duration);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid duration: " + duration, ex);
        }
    }
}

