/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.util;

import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;
import com.digiwin.dap.middleware.lmc.http.utils.ResourceManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LMCUtils {
    public static final ResourceManager LMC_RESOURCE_MANAGER = ResourceManager.getInstance("i18n/lmc");
    public static final ResourceManager COMMON_RESOURCE_MANAGER = ResourceManager.getInstance("i18n/common");
    private static final String BUCKET_NAMING_CREATION_REGEX = "^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$";
    private static final String BUCKET_NAMING_REGEX = "^[a-z0-9][a-z0-9-_]{1,61}[a-z0-9]$";
    private static final String ENDPOINT_REGEX = "^[a-zA-Z0-9._-]+$";

    public static boolean validateEndpoint(String endpoint) {
        if (endpoint == null) {
            return false;
        }
        return endpoint.matches(ENDPOINT_REGEX);
    }

    public static void ensureEndpointValid(String endpoint) {
        if (!LMCUtils.validateEndpoint(endpoint)) {
            throw new IllegalArgumentException(LMC_RESOURCE_MANAGER.getFormattedString("EndpointInvalid", endpoint));
        }
    }

    public static boolean validateBucketName(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        return bucketName.matches(BUCKET_NAMING_REGEX);
    }

    public static void ensureBucketNameValid(String bucketName) {
        if (!LMCUtils.validateBucketName(bucketName)) {
            throw new IllegalArgumentException(LMC_RESOURCE_MANAGER.getFormattedString("BucketNameInvalid", bucketName));
        }
    }

    public static boolean validateBucketNameCreation(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        return bucketName.matches(BUCKET_NAMING_CREATION_REGEX);
    }

    public static void ensureBucketNameCreationValid(String bucketName) {
        if (!LMCUtils.validateBucketNameCreation(bucketName)) {
            throw new IllegalArgumentException(LMC_RESOURCE_MANAGER.getFormattedString("BucketNameInvalid", bucketName));
        }
    }

    public static boolean validateObjectKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        byte[] bytes = null;
        try {
            bytes = key.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        char[] keyChars = key.toCharArray();
        char firstChar = keyChars[0];
        if (firstChar == '\\') {
            return false;
        }
        return bytes.length > 0 && bytes.length < 1024;
    }

    public static void ensureObjectKeyValid(String key) {
        if (!LMCUtils.validateObjectKey(key)) {
            throw new IllegalArgumentException(LMC_RESOURCE_MANAGER.getFormattedString("ObjectKeyInvalid", key));
        }
    }

    public static void ensureLiveChannelNameValid(String liveChannelName) {
        if (!LMCUtils.validateObjectKey(liveChannelName)) {
            throw new IllegalArgumentException(LMC_RESOURCE_MANAGER.getFormattedString("LiveChannelNameInvalid", liveChannelName));
        }
    }

    private static boolean cnameExcludeFilter(String hostToFilter, List<String> excludeList) {
        if (hostToFilter != null && !hostToFilter.trim().isEmpty()) {
            String canonicalHost = hostToFilter.toLowerCase();
            for (String excl : excludeList) {
                if (!canonicalHost.endsWith(excl)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Host name can not be null.");
    }

    public static long dateToTimestamp(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date timestampToDate(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static String getOrEmpty(Map<String, String> map, String key) {
        return map.containsKey(key) ? map.get(key) : "";
    }

    public static String safeToString(Object object) {
        return object == null ? null : object.toString();
    }

    private static long parseLongWithoutSuffix(String s) {
        return Long.parseLong(s.substring(0, s.length() - 1).trim());
    }

    public static long parseDuration(String s) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Duration could not be empty: " + s);
        }
        if (s.endsWith("s")) {
            return LMCUtils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("m")) {
            return 60L * LMCUtils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("h")) {
            return 3600L * LMCUtils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("d")) {
            return 86400L * LMCUtils.parseLongWithoutSuffix(s);
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("'" + s + "' is not a valid duration. Should be numeric value followed by a unit, i.e. 20s. Valid units are s, m, h and d.");
        }
    }

    public static void safeCloseResponse(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

