package com.digiwin.dap.middleware.lmc.internal;

import com.digiwin.dap.middleware.lmc.util.Args;

import java.net.URI;

/**
 * LMC resource uri
 *
 * @author chenzhuang
 * @date 2021/4/25
 */
public class LMCResourceUri {

    public static final String OPLOG = "/api/lmc/v1/oplog";
    public static final String OPLOG_COMPARE = "/api/lmc/v1/oplog/compare";
    public static final String OPLOG_COMPARE_DIRECT = "/api/lmc/v1/oplog/compare/direct";
    public static final String EVENTLOG = "/api/lmc/v1/eventlog";
    public static final String EVENTLOG_BATCH = "/api/lmc/v1/eventlog/batch";
    public static final String DEVLOG = "/api/lmc/v1/devlog";
    public static final String DEVLOG_BATCH  = "/api/lmc/v1/devlog/batch";
    public static final String SAVE_CHANGE_LOGS = "/api/lmc/v1/buckets/digiwincloud/changelogs/result";
    public static final String DATA_COMPARISON = "/api/lmc/v1/buckets/digiwincloud/changelogs";
    public static final String FIND_OPLOG_BY_PAGE = "/api/lmc/v1/oplogs";
    public static final String FIND_DEVLOG_BY_PAGE = "/api/lmc/v1/devlogs";
    public static final String FIND_EVENTLOG_BY_PAGE = "/api/lmc/v1/eventlogs";

    public static URI getSaveOpLogUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + OPLOG);
    }

    public static URI getSaveOpLogCompareUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + OPLOG_COMPARE);
    }

    public static URI getSaveOpLogCompareDirectUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + OPLOG_COMPARE_DIRECT);
    }

    public static URI getSaveEventLogUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + EVENTLOG);
    }
    public static URI getSaveEventLogBatchUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + EVENTLOG_BATCH);
    }

    public static URI getSaveDevLogUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + DEVLOG);
    }
    public static URI getSaveDevLogBatchUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + DEVLOG_BATCH);
    }

    public static URI getSaveChangeLogsUrl(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + SAVE_CHANGE_LOGS);
    }

    public static URI getDataComparison(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + DATA_COMPARISON);
    }

    public static URI getFindOpLogByPage(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + FIND_OPLOG_BY_PAGE);
    }

    public static URI getFindDevLogByPage(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + FIND_DEVLOG_BY_PAGE);
    }

    public static URI getFindEventLogByPage(String host) {
        Args.notNullOrEmpty(host, "endpoint");
        return URI.create(host + FIND_EVENTLOG_BY_PAGE);
    }


}
