/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc;

import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.common.serializer.Constants;
import com.digiwin.dap.middleware.lmc.exception.LMCException;
import com.digiwin.dap.middleware.lmc.http.client.HttpMethod;
import com.digiwin.dap.middleware.lmc.http.comm.DefaultServiceClient;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ServiceClient;
import com.digiwin.dap.middleware.lmc.internal.LMCOperation;
import com.digiwin.dap.middleware.lmc.internal.LMCResourceUri;
import com.digiwin.dap.middleware.lmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.lmc.internal.model.ModifiedInfo;
import com.digiwin.dap.middleware.lmc.internal.model.PageData;
import com.digiwin.dap.middleware.lmc.internal.model.StdData;
import com.digiwin.dap.middleware.lmc.internal.model.entity.ChangeInfo;
import com.digiwin.dap.middleware.lmc.internal.model.entity.CompareInfo;
import com.digiwin.dap.middleware.lmc.internal.model.entity.DevLog;
import com.digiwin.dap.middleware.lmc.internal.model.entity.EventLog;
import com.digiwin.dap.middleware.lmc.internal.model.entity.OpLog;
import com.digiwin.dap.middleware.lmc.request.DevLogDTO;
import com.digiwin.dap.middleware.lmc.request.EventLogDTO;
import com.digiwin.dap.middleware.lmc.request.ModifiedInfoRequest;
import com.digiwin.dap.middleware.lmc.request.OpLogDTO;
import com.digiwin.dap.middleware.lmc.request.OpLogRequest;
import com.digiwin.dap.middleware.lmc.request.PageDevLogRequest;
import com.digiwin.dap.middleware.lmc.request.PageEventLogRequest;
import com.digiwin.dap.middleware.lmc.request.PageOpLogRequest;
import com.digiwin.dap.middleware.lmc.request.SaveCompareOpLog;
import com.digiwin.dap.middleware.lmc.request.SaveCompareOpLogRequest;
import com.digiwin.dap.middleware.lmc.request.SaveDevLog;
import com.digiwin.dap.middleware.lmc.request.SaveDevLogRequest;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.digiwin.dap.middleware.lmc.request.SaveEventLogBatchRequest;
import com.digiwin.dap.middleware.lmc.request.SaveEventLogRequest;
import com.digiwin.dap.middleware.lmc.request.SaveOpLog;
import com.digiwin.dap.middleware.lmc.request.SaveOpLogRequest;
import com.digiwin.dap.middleware.lmc.util.Args;
import com.digiwin.dap.middleware.lmc.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMCClient
implements LMC {
    private static final Logger logger = LoggerFactory.getLogger(LMCClient.class);
    private String endpoint;
    private String app;
    private String appToken;
    private String appSecret;
    private String sourceIp;
    private ServiceClient serviceClient;
    private LMCOperation lmcOperation;

    public LMCClient(String endpoint, String app) {
        this(endpoint, app, NetworkUtils.getLocalMachineIP());
    }

    public LMCClient(String endpoint, String app, String sourceIp) {
        this.serviceClient = new DefaultServiceClient();
        this.configure(endpoint, app, sourceIp);
    }

    public LMCClient(String endpoint, String app, ServiceClient serviceClient) {
        this(endpoint, app, NetworkUtils.getLocalMachineIP(), serviceClient);
    }

    public LMCClient(String endpoint, String app, String sourceIp, ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
        this.configure(endpoint, app, sourceIp);
    }

    public LMCClient(String endpoint, String app, String appToken, String appSecret) {
        this(endpoint, app, appToken, appSecret, NetworkUtils.getLocalMachineIP());
    }

    public LMCClient(String endpoint, String app, String appToken, String appSecret, String sourceIp) {
        this.serviceClient = new DefaultServiceClient();
        this.configure(endpoint, app, appToken, appSecret, sourceIp);
    }

    public LMCClient(String endpoint, String app, String appToken, String appSecret, ServiceClient serviceClient) {
        this(endpoint, app, appToken, appSecret, NetworkUtils.getLocalMachineIP(), serviceClient);
    }

    public LMCClient(String endpoint, String app, String appToken, String appSecret, String sourceIp, ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
        this.configure(endpoint, app, appToken, appSecret, sourceIp);
    }

    private void configure(String endpoint, String app, String sourceIp) {
        this.configure(endpoint, app, null, null, sourceIp);
    }

    private void configure(String endpoint, String app, String appToken, String appSecret, String sourceIp) {
        this.endpoint = endpoint;
        this.app = app;
        this.appToken = appToken;
        this.appSecret = appSecret;
        this.sourceIp = sourceIp;
        if (sourceIp == null || sourceIp.isEmpty()) {
            this.sourceIp = NetworkUtils.getLocalMachineIP();
        }
        this.initOperations();
    }

    private void initOperations() {
        this.lmcOperation = new LMCOperation(this.serviceClient);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    @Override
    public OpLog saveOpLog(SaveOpLog dto, String userToken) throws LMCException {
        Args.notNull(dto, "SaveOpLog");
        Args.notNullOrEmpty(userToken, "userToken");
        dto.setAppId(Optional.ofNullable(dto.getAppId()).orElse(this.app));
        Args.notNullOrEmpty(dto.getModuleId(), "moduleId");
        Args.notNullOrEmpty(dto.getActId(), "actId");
        Args.notNullOrEmpty(dto.getOperationType(), "operationType");
        SaveOpLogRequest request = new SaveOpLogRequest(dto);
        request.addHeader("digi-middleware-auth-user", userToken);
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getSaveOpLogUrl(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.saveOpLogResponseParser);
    }

    @Override
    public OpLog saveOpLog(SaveOpLog dto, List<ChangeInfo> changeInfoList, String userToken) throws LMCException {
        Args.notNull(dto, "SaveOpLog");
        dto.setChangeInfoList(changeInfoList);
        return this.saveOpLog(dto, userToken);
    }

    @Override
    public OpLog saveCompareOpLog(SaveCompareOpLog dto, String userToken) throws LMCException {
        Args.notNull(dto, "SaveCompareOpLog");
        Args.notNullOrEmpty(userToken, "userToken");
        dto.setAppId(Optional.ofNullable(dto.getAppId()).orElse(this.app));
        Args.notNullOrEmpty(dto.getModuleId(), "moduleId");
        Args.notNullOrEmpty(dto.getActId(), "actId");
        Args.notNullOrEmpty(dto.getOperationType(), "operationType");
        SaveCompareOpLogRequest request = new SaveCompareOpLogRequest(dto);
        request.addHeader("digi-middleware-auth-user", userToken);
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getSaveOpLogCompareUrl(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.saveOpLogResponseParser);
    }

    @Override
    public OpLog saveCompareOpLog(SaveCompareOpLog dto, Map<String, Object> originJson, Map<String, Object> modifyJson, String userToken) throws LMCException {
        Args.notNull(dto, "SaveCompareOpLog");
        dto.setOriginJson(originJson);
        dto.setModifyJson(modifyJson);
        return this.saveCompareOpLog(dto, userToken);
    }

    @Override
    public OpLog saveCompareOpLogDirect(SaveCompareOpLog dto, String userToken) throws LMCException {
        Args.notNull(dto, "SaveCompareOpLog");
        Args.notNullOrEmpty(userToken, "userToken");
        dto.setAppId(Optional.ofNullable(dto.getAppId()).orElse(this.app));
        Args.notNullOrEmpty(dto.getModuleId(), "moduleId");
        Args.notNullOrEmpty(dto.getActId(), "actId");
        Args.notNullOrEmpty(dto.getOperationType(), "operationType");
        Args.notNull(dto.getPrimaryKeyList(), "primaryKeyList");
        Args.notNull(dto.getLogFieldList(), "logFieldList");
        SaveCompareOpLogRequest request = new SaveCompareOpLogRequest(dto);
        request.addHeader("digi-middleware-auth-user", userToken);
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getSaveOpLogCompareDirectUrl(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.saveOpLogResponseParser);
    }

    @Override
    public OpLog saveCompareOpLogDirect(SaveCompareOpLog dto, Map<String, Object> originJson, Map<String, Object> modifyJson, List<Map<String, String>> primaryKeyList, List<Map<String, String>> logFieldList, String userToken) throws Exception {
        Args.notNull(dto, "SaveCompareOpLog");
        dto.setOriginJson(originJson);
        dto.setModifyJson(modifyJson);
        dto.setPrimaryKeyList(primaryKeyList);
        dto.setLogFieldList(logFieldList);
        return this.saveCompareOpLogDirect(dto, userToken);
    }

    @Override
    public PageData<OpLog> findOpLogByPage(OpLogDTO dto, int pageNum, int pageSize, Map<String, Object> orders, String userToken) {
        PageOpLogRequest request = new PageOpLogRequest(dto, (Integer)pageNum, pageSize, orders);
        return this.findOpLogByPage(request, userToken);
    }

    @Override
    public PageData<OpLog> findOpLogByPage(PageOpLogRequest request, String userToken) {
        Args.notNullOrEmpty(userToken, "userToken");
        request.setOpLogDTO(Optional.ofNullable(request.getOpLogDTO()).orElseGet(OpLogDTO::new));
        request.getOpLogDTO().setAppId(Optional.ofNullable(request.getOpLogDTO().getAppId()).orElse(this.app));
        request.addHeader("digi-middleware-auth-user", userToken);
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getFindOpLogByPage(this.endpoint), HttpMethod.GET, request.getHeaders(), request.getParameters(), null);
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.pageDataOpLogResponseParser);
    }

    @Override
    public DevLog saveDevLog(SaveDevLog dto) throws LMCException {
        return this.saveDevLog(dto, null);
    }

    @Override
    public DevLog saveDevLog(SaveDevLog dto, String userToken) throws LMCException {
        Args.notNull(dto, "SaveDevLog");
        dto.setAppId(Optional.ofNullable(dto.getAppId()).orElse(this.app));
        dto.setTime(Optional.ofNullable(dto.getTime()).orElseGet(() -> Constants._sdf.format(new Date())));
        Args.notNullOrEmpty(dto.getLevel(), "level");
        Args.notNullOrEmpty(dto.getMessage(), "message");
        SaveDevLogRequest request = new SaveDevLogRequest(dto);
        if (userToken != null && !"".equals(userToken)) {
            request.addHeader("digi-middleware-auth-user", userToken);
        }
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getSaveDevLogUrl(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.saveDevLogResponseParser);
    }

    @Override
    public PageData<DevLog> findDevLogByPage(DevLogDTO dto, int pageNum, int pageSize, Map<String, Object> orders, String userToken) {
        PageDevLogRequest request = new PageDevLogRequest(dto, (Integer)pageNum, pageSize, orders);
        return this.findDevLogByPage(request, userToken);
    }

    @Override
    public PageData<DevLog> findDevLogByPage(PageDevLogRequest request, String userToken) {
        Args.notNullOrEmpty(userToken, "userToken");
        request.setDevLogDTO(Optional.ofNullable(request.getDevLogDTO()).orElseGet(DevLogDTO::new));
        request.getDevLogDTO().setAppId(Optional.ofNullable(request.getDevLogDTO().getAppId()).orElse(this.app));
        request.addHeader("digi-middleware-auth-user", userToken);
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getFindDevLogByPage(this.endpoint), HttpMethod.GET, request.getHeaders(), request.getParameters(), null);
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.pageDataDevLogResponseParser);
    }

    @Override
    public EventLog saveEventLog(SaveEventLog dto) throws Exception {
        return this.saveEventLog(dto, null);
    }

    @Override
    public EventLog saveEventLog(SaveEventLog dto, String userToken) throws LMCException {
        Args.notNull(dto, "SaveEventLog");
        dto.setAppId(Optional.ofNullable(dto.getAppId()).orElse(this.app));
        Args.notNullOrEmpty(dto.getEventName(), "eventName");
        Args.notNull(dto.getEventType(), "eventType");
        SaveEventLogRequest request = new SaveEventLogRequest(dto);
        if (userToken != null && !"".equals(userToken)) {
            request.addHeader("digi-middleware-auth-user", userToken);
        }
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getSaveEventLogUrl(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.saveEventLogResponseParser);
    }

    @Override
    public StdData saveEventLogBatch(List<SaveEventLog> saveEventLogList) throws Exception {
        return this.saveEventLogBatch(saveEventLogList, null);
    }

    @Override
    public StdData saveEventLogBatch(List<SaveEventLog> saveEventLogList, String userToken) throws Exception {
        if (saveEventLogList == null || saveEventLogList.isEmpty()) {
            return StdData.ok();
        }
        for (SaveEventLog saveEventLog : saveEventLogList) {
            saveEventLog.setAppId(Optional.ofNullable(saveEventLog.getAppId()).orElse(this.app));
            Args.notNullOrEmpty(saveEventLog.getEventName(), "eventName");
            Args.notNull(saveEventLog.getEventType(), "eventType");
        }
        SaveEventLogBatchRequest request = new SaveEventLogBatchRequest(saveEventLogList);
        if (userToken != null && !"".equals(userToken)) {
            request.addHeader("digi-middleware-auth-user", userToken);
        }
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getSaveEventLogBatchUrl(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.stdDataResponseParser);
    }

    @Override
    public PageData<EventLog> findEventLogByPage(EventLogDTO dto, int pageNum, int pageSize, Map<String, Object> orders, String userToken) {
        PageEventLogRequest request = new PageEventLogRequest(dto, (Integer)pageNum, pageSize, orders);
        return this.findEventLogByPage(request, userToken);
    }

    @Override
    public PageData<EventLog> findEventLogByPage(PageEventLogRequest request, String userToken) {
        Args.notNullOrEmpty(userToken, "userToken");
        request.setEventLogDTO(Optional.ofNullable(request.getEventLogDTO()).orElseGet(EventLogDTO::new));
        request.getEventLogDTO().setAppId(Optional.ofNullable(request.getEventLogDTO().getAppId()).orElse(this.app));
        request.addHeader("digi-middleware-auth-user", userToken);
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getFindEventLogByPage(this.endpoint), HttpMethod.GET, request.getHeaders(), request.getParameters(), null);
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.pageDataEventLogResponseParser);
    }

    @Override
    @Deprecated
    public OpLog saveChangeLogs(CompareInfo dto, String userToken) throws LMCException {
        OpLogRequest request = new OpLogRequest(dto);
        request.addHeader("digi-middleware-auth-user", userToken);
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getSaveChangeLogsUrl(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.saveOpLogResponseParser);
    }

    @Override
    @Deprecated
    public OpLog dataComparison(ModifiedInfo dto, String userToken) throws LMCException {
        ModifiedInfoRequest request = new ModifiedInfoRequest(dto);
        request.addHeader("digi-middleware-auth-user", userToken);
        request.addHeader("Content-Type", "application/json");
        RequestMessage requestMessage = this.buildRequest(LMCResourceUri.getDataComparison(this.endpoint), HttpMethod.POST, request.getHeaders(), request.getEntity());
        return this.lmcOperation.doOperation(requestMessage, ResponseParsers.saveOpLogResponseParser);
    }

    @Override
    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        }
        catch (Exception e) {
            logger.error("shutdown throw exception: ", (Throwable)e);
        }
    }

    public RequestMessage buildRequest(URI endpoint, HttpMethod method, Map<String, String> headers, HttpEntity httpEntity) {
        return this.buildRequest(endpoint, method, headers, null, httpEntity);
    }

    public RequestMessage buildRequest(URI endpoint, HttpMethod method, Map<String, String> headers, Map<String, String> parameters, HttpEntity httpEntity) {
        return this.buildRequest(endpoint, method, headers, parameters, httpEntity, new ByteArrayInputStream(new byte[0]), 0L);
    }

    private RequestMessage buildRequest(URI endpoint, HttpMethod httpMethod, Map<String, String> headers, Map<String, String> parameters, HttpEntity httpEntity, InputStream content, long size) {
        RequestMessage request = new RequestMessage();
        HashMap<String, String> sentHeaders = new HashMap<String, String>(headers);
        if (size > 0L) {
            sentHeaders.put("Content-Length", size + "");
        }
        sentHeaders.put("digi-middleware-auth-app", this.appToken);
        sentHeaders.put("digi-middleware-auth-app-secret", this.appSecret);
        request.setMethod(httpMethod);
        request.setEndpoint(endpoint);
        request.setHeaders(sentHeaders);
        request.setContent(size == 0L ? new ByteArrayInputStream(new byte[0]) : content);
        request.setContentLength(size);
        request.setParameters(parameters);
        request.setHttpEntity(httpEntity);
        return request;
    }
}

